
package org.mule.module.fws.config.spring;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.module.fws.config.PutInboundShipmentDataMessageProcessor;
import org.mule.util.TemplateParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class PutInboundShipmentDataDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public PutInboundShipmentDataDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(PutInboundShipmentDataMessageProcessor.class.getName());
        String configRef = element.getAttribute("config-ref");
        if ((configRef!= null)&&(!StringUtils.isBlank(configRef))) {
            builder.addPropertyValue("moduleObject", configRef);
        }
        if ((element.getAttribute("shipmentId")!= null)&&(!StringUtils.isBlank(element.getAttribute("shipmentId")))) {
            builder.addPropertyValue("shipmentId", element.getAttribute("shipmentId"));
        }
        if ((element.getAttribute("shipmentName")!= null)&&(!StringUtils.isBlank(element.getAttribute("shipmentName")))) {
            builder.addPropertyValue("shipmentName", element.getAttribute("shipmentName"));
        }
        if ((element.getAttribute("destinationFulfillmentCenter")!= null)&&(!StringUtils.isBlank(element.getAttribute("destinationFulfillmentCenter")))) {
            builder.addPropertyValue("destinationFulfillmentCenter", element.getAttribute("destinationFulfillmentCenter"));
        }
        Element shipFromAddressListElement = null;
        shipFromAddressListElement = DomUtils.getChildElementByTagName(element, "ship-from-address");
        List<Element> shipFromAddressListChilds = null;
        if (shipFromAddressListElement!= null) {
            String shipFromAddressRef = shipFromAddressListElement.getAttribute("ref");
            if ((shipFromAddressRef!= null)&&(!StringUtils.isBlank(shipFromAddressRef))) {
                if ((!shipFromAddressRef.startsWith(patternInfo.getPrefix()))&&(!shipFromAddressRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("shipFromAddress", new RuntimeBeanReference(shipFromAddressRef));
                } else {
                    builder.addPropertyValue("shipFromAddress", shipFromAddressRef);
                }
            } else {
                ManagedMap shipFromAddress = new ManagedMap();
                shipFromAddressListChilds = DomUtils.getChildElementsByTagName(shipFromAddressListElement, "ship-from-addres");
                if (shipFromAddressListChilds!= null) {
                    if (shipFromAddressListChilds.size() == 0) {
                        shipFromAddressListChilds = DomUtils.getChildElements(shipFromAddressListElement);
                    }
                    for (Element shipFromAddressChild: shipFromAddressListChilds) {
                        String shipFromAddressValueRef = shipFromAddressChild.getAttribute("value-ref");
                        String shipFromAddressKeyRef = shipFromAddressChild.getAttribute("key-ref");
                        Object valueObject = null;
                        Object keyObject = null;
                        if ((shipFromAddressValueRef!= null)&&(!StringUtils.isBlank(shipFromAddressValueRef))) {
                            valueObject = new RuntimeBeanReference(shipFromAddressValueRef);
                        } else {
                            valueObject = shipFromAddressChild.getTextContent();
                        }
                        if ((shipFromAddressKeyRef!= null)&&(!StringUtils.isBlank(shipFromAddressKeyRef))) {
                            keyObject = new RuntimeBeanReference(shipFromAddressKeyRef);
                        } else {
                            keyObject = shipFromAddressChild.getAttribute("key");
                        }
                        if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                            keyObject = shipFromAddressChild.getTagName();
                        }
                        shipFromAddress.put(keyObject, valueObject);
                    }
                }
                builder.addPropertyValue("shipFromAddress", shipFromAddress);
            }
        }
        if (element.hasAttribute("labelPreference")) {
            builder.addPropertyValue("labelPreference", element.getAttribute("labelPreference"));
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        MutablePropertyValues propertyValues = parserContent.getContainingBeanDefinition().getPropertyValues();
        if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.config.spring.factories.PollingMessageSourceFactoryBean")) {
            propertyValues.addPropertyValue("messageProcessor", definition);
        } else {
            if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.enricher.MessageEnricher")) {
                propertyValues.addPropertyValue("enrichmentMessageProcessor", definition);
            } else {
                PropertyValue messageProcessors = propertyValues.getPropertyValue("messageProcessors");
                if ((messageProcessors == null)||(messageProcessors.getValue() == null)) {
                    propertyValues.addPropertyValue("messageProcessors", new ManagedList());
                }
                List listMessageProcessors = ((List) propertyValues.getPropertyValue("messageProcessors").getValue());
                listMessageProcessors.add(definition);
            }
        }
        return definition;
    }

    protected String getAttributeValue(Element element, String attributeName) {
        if (!StringUtils.isEmpty(element.getAttribute(attributeName))) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    private String generateChildBeanName(Element element) {
        String id = SpringXMLUtils.getNameOrId(element);
        if (StringUtils.isBlank(id)) {
            String parentId = SpringXMLUtils.getNameOrId(((Element) element.getParentNode()));
            return ((("."+ parentId)+":")+ element.getLocalName());
        } else {
            return id;
        }
    }

}
