/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.git;

import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.DeleteBranchCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public class GitConnector {
    private String directory;

    public void cloneRepository(String uri, boolean bare, String remote, String branch, String overrideDirectory) {
        File dir = this.resolveDirectory(overrideDirectory);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new RuntimeException("Directory " + dir.getAbsolutePath() + " cannot be created");
        }
        CloneCommand cloneCommand = Git.cloneRepository();
        cloneCommand.setBare(bare);
        cloneCommand.setDirectory(dir);
        cloneCommand.setRemote(remote);
        cloneCommand.setBranch(branch);
        cloneCommand.setURI(uri);
        try {
            Git git = cloneCommand.call();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot clone repository", e);
        }
    }

    public void add(String filePattern, String overrideDirectory) {
        try {
            Git git = new Git(this.getGitRepo(overrideDirectory));
            AddCommand add = git.add();
            add.addFilepattern(filePattern);
            add.call();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot add " + filePattern, e);
        }
    }

    public void createBranch(String name, boolean force, String startPoint, String overrideDirectory) {
        try {
            Git git = new Git(this.getGitRepo(overrideDirectory));
            CreateBranchCommand createBranch = git.branchCreate();
            createBranch.setName(name);
            createBranch.setForce(force);
            createBranch.setStartPoint(startPoint);
            createBranch.call();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create branch " + name, e);
        }
    }

    public void deleteBranch(String name, boolean force, String overrideDirectory) {
        try {
            Git git = new Git(this.getGitRepo(overrideDirectory));
            DeleteBranchCommand deleteBranch = git.branchDelete();
            deleteBranch.setBranchNames(new String[]{name});
            deleteBranch.setForce(force);
            deleteBranch.call();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create branch " + name, e);
        }
    }

    public void commit(String msg, String committerName, String committerEmail, String authorName, String authorEmail, String overrideDirectory) {
        try {
            Git git = new Git(this.getGitRepo(overrideDirectory));
            CommitCommand commit = git.commit();
            if (authorName != null && authorEmail != null) {
                commit.setAuthor(authorName, authorEmail);
            }
            commit.setCommitter(committerName, committerEmail);
            commit.setMessage(msg);
            commit.call();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to commit", e);
        }
    }

    public void push(String remote, boolean force, String overrideDirectory) {
        try {
            Git git = new Git(this.getGitRepo(overrideDirectory));
            PushCommand push = git.push();
            push.setRemote(remote);
            push.setForce(force);
            push.call();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to push to " + remote, e);
        }
    }

    public void pull(String overrideDirectory) {
        try {
            Git git = new Git(this.getGitRepo(overrideDirectory));
            PullCommand pull = git.pull();
            pull.call();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to pull", e);
        }
    }

    public void fetch(String overrideDirectory) {
        try {
            Git git = new Git(this.getGitRepo(overrideDirectory));
            FetchCommand fetch = git.fetch();
            fetch.call();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to fetch", e);
        }
    }

    public void checkout(String branch, String startPoint, String overrideDirectory) {
        try {
            Git git = new Git(this.getGitRepo(overrideDirectory));
            CheckoutCommand checkout = git.checkout();
            checkout.setName(branch);
            if (startPoint != null) {
                checkout.setCreateBranch(true);
                checkout.setStartPoint(startPoint);
            }
            checkout.call();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to fetch", e);
        }
    }

    private File resolveDirectory(String overrideDirectory) {
        File dir = overrideDirectory == null ? new File(this.directory) : new File(overrideDirectory);
        return dir;
    }

    private Repository getGitRepo(String overrideDirectory) throws IOException {
        File dir = this.resolveDirectory(overrideDirectory);
        if (!dir.exists()) {
            throw new RuntimeException("Directory " + dir.getAbsolutePath() + " does not exists");
        }
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        builder.setWorkTree(dir);
        return builder.build();
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }
}

