/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.submodule;

import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FS;

public class SubmoduleWalk {
    private final Repository repository;
    private final TreeWalk walk;
    private StoredConfig repoConfig;
    private FileBasedConfig modulesConfig;
    private String path;

    public static SubmoduleWalk forIndex(Repository repository) throws IOException {
        SubmoduleWalk generator = new SubmoduleWalk(repository);
        generator.setTree(new DirCacheIterator(repository.readDirCache()));
        return generator;
    }

    public static SubmoduleWalk forPath(Repository repository, AnyObjectId treeId, String path) throws IOException {
        SubmoduleWalk generator = new SubmoduleWalk(repository);
        generator.setTree(treeId);
        PathFilter filter = PathFilter.create(path);
        generator.setFilter(filter);
        while (generator.next()) {
            if (!filter.isDone(generator.walk)) continue;
            return generator;
        }
        return null;
    }

    public static SubmoduleWalk forPath(Repository repository, AbstractTreeIterator iterator, String path) throws IOException {
        SubmoduleWalk generator = new SubmoduleWalk(repository);
        generator.setTree(iterator);
        PathFilter filter = PathFilter.create(path);
        generator.setFilter(filter);
        while (generator.next()) {
            if (!filter.isDone(generator.walk)) continue;
            return generator;
        }
        return null;
    }

    public static File getSubmoduleDirectory(Repository parent, String path) {
        return new File(parent.getWorkTree(), path);
    }

    public static Repository getSubmoduleRepository(Repository parent, String path) throws IOException {
        File directory = SubmoduleWalk.getSubmoduleGitDirectory(parent, path);
        if (!directory.isDirectory()) {
            return null;
        }
        try {
            return ((RepositoryBuilder)((RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().setMustExist(true)).setFS(FS.DETECTED)).setGitDir(directory)).build();
        }
        catch (RepositoryNotFoundException e) {
            return null;
        }
    }

    public static File getSubmoduleGitDirectory(Repository parent, String path) {
        return new File(SubmoduleWalk.getSubmoduleDirectory(parent, path), ".git");
    }

    public SubmoduleWalk(Repository repository) throws IOException {
        this.repository = repository;
        this.repoConfig = repository.getConfig();
        this.walk = new TreeWalk(repository);
        this.walk.setRecursive(true);
    }

    private void loadModulesConfig() throws IOException, ConfigInvalidException {
        if (this.modulesConfig == null) {
            File modulesFile = new File(this.repository.getWorkTree(), ".gitmodules");
            FileBasedConfig config = new FileBasedConfig(modulesFile, this.repository.getFS());
            config.load();
            this.modulesConfig = config;
        }
    }

    public SubmoduleWalk setFilter(TreeFilter filter) {
        this.walk.setFilter(filter);
        return this;
    }

    public SubmoduleWalk setTree(AbstractTreeIterator iterator) throws CorruptObjectException {
        this.walk.addTree(iterator);
        return this;
    }

    public SubmoduleWalk setTree(AnyObjectId treeId) throws IOException {
        this.walk.addTree(treeId);
        return this;
    }

    public SubmoduleWalk reset() {
        this.repoConfig = this.repository.getConfig();
        this.modulesConfig = null;
        this.walk.reset();
        return this;
    }

    public File getDirectory() {
        return SubmoduleWalk.getSubmoduleDirectory(this.repository, this.path);
    }

    public File getGitDirectory() {
        return SubmoduleWalk.getSubmoduleGitDirectory(this.repository, this.path);
    }

    public boolean next() throws IOException {
        while (this.walk.next()) {
            if (FileMode.GITLINK != this.walk.getFileMode(0)) continue;
            this.path = this.walk.getPathString();
            return true;
        }
        this.path = null;
        return false;
    }

    public String getPath() {
        return this.path;
    }

    public ObjectId getObjectId() {
        return this.walk.getObjectId(0);
    }

    public String getModulesPath() throws IOException, ConfigInvalidException {
        this.loadModulesConfig();
        return this.modulesConfig.getString("submodule", this.path, "path");
    }

    public String getConfigUrl() throws IOException, ConfigInvalidException {
        return this.repoConfig.getString("submodule", this.path, "url");
    }

    public String getModulesUrl() throws IOException, ConfigInvalidException {
        this.loadModulesConfig();
        return this.modulesConfig.getString("submodule", this.path, "url");
    }

    public String getConfigUpdate() throws IOException, ConfigInvalidException {
        return this.repoConfig.getString("submodule", this.path, "update");
    }

    public String getModulesUpdate() throws IOException, ConfigInvalidException {
        this.loadModulesConfig();
        return this.modulesConfig.getString("submodule", this.path, "update");
    }

    public boolean hasGitDirectory() {
        return this.getGitDirectory().isDirectory();
    }

    public Repository getRepository() throws IOException {
        return SubmoduleWalk.getSubmoduleRepository(this.repository, this.path);
    }

    public ObjectId getHead() throws IOException {
        Repository subRepo = this.getRepository();
        return subRepo != null ? subRepo.resolve("HEAD") : null;
    }

    public String getHeadRef() throws IOException {
        Repository subRepo = this.getRepository();
        if (subRepo == null) {
            return null;
        }
        Ref head = subRepo.getRef("HEAD");
        return head != null ? head.getLeaf().getName() : null;
    }
}

