
package org.mule.module.git.config.spring;

import org.springframework.beans.factory.xml.NamespaceHandlerSupport;


/**
 * Registers bean definitions parsers for handling elements in <code>http://www.mulesoft.org/schema/mule/git</code>.
 * 
 */
public class GitConnectorNamespaceHandler
    extends NamespaceHandlerSupport
{


    /**
     * Invoked by the {@link DefaultBeanDefinitionDocumentReader} after construction but before any custom elements are parsed. 
     * @see NamespaceHandlerSupport#registerBeanDefinitionParser(String, BeanDefinitionParser)
     * 
     */
    public void init() {
        registerBeanDefinitionParser("config", new GitConnectorConfigDefinitionParser());
        registerBeanDefinitionParser("clone", new CloneRepositoryDefinitionParser());
        registerBeanDefinitionParser("add", new AddDefinitionParser());
        registerBeanDefinitionParser("create-branch", new CreateBranchDefinitionParser());
        registerBeanDefinitionParser("delete-branch", new DeleteBranchDefinitionParser());
        registerBeanDefinitionParser("commit", new CommitDefinitionParser());
        registerBeanDefinitionParser("push", new PushDefinitionParser());
        registerBeanDefinitionParser("pull", new PullDefinitionParser());
        registerBeanDefinitionParser("fetch", new FetchDefinitionParser());
        registerBeanDefinitionParser("checkout", new CheckoutDefinitionParser());
    }

}
