/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jpa;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.criteria.CriteriaQuery;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.transaction.TransactionFactory;
import org.mule.module.jpa.JPATransactionFactory;
import org.mule.module.jpa.JPAUtils;
import org.mule.module.jpa.command.Detach;
import org.mule.module.jpa.command.Find;
import org.mule.module.jpa.command.JPACommand;
import org.mule.module.jpa.command.Merge;
import org.mule.module.jpa.command.Persist;
import org.mule.module.jpa.command.Query;
import org.mule.util.StringUtils;

public class JPAModule
implements MuleContextAware {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    EntityManagerFactory entityManagerFactory;
    MuleContext muleContext;

    @PostConstruct
    public void connect() throws Exception {
        this.muleContext.getTransactionFactoryManager().registerTransactionFactory(EntityManagerFactory.class, (TransactionFactory)new JPATransactionFactory());
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public Object query(CriteriaQuery criteria, String statement, String namedQuery, Object queryParameters, Boolean flush) throws Exception {
        if (this.logger.isDebugEnabled()) {
            if (StringUtils.isNotBlank((String)statement)) {
                this.logger.debug((Object)String.format("Performing query with statement %s and parameters %s", statement, queryParameters));
            } else if (StringUtils.isNotBlank((String)namedQuery)) {
                this.logger.debug((Object)String.format("Performing query with named query %s and parameters %s", statement, queryParameters));
            } else {
                this.logger.debug((Object)("Attempting criteria query with payload: " + criteria));
            }
        }
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)statement)) {
            parameterMap.put("statement", statement);
        }
        if (StringUtils.isNotBlank((String)namedQuery)) {
            parameterMap.put("namedQuery", statement);
        }
        if (namedQuery != null) {
            parameterMap.put("namedQuery", namedQuery);
        }
        parameterMap.put("queryParameters", queryParameters);
        return this.perform(criteria, new Query(), parameterMap, flush);
    }

    public Object persist(Object entity, Boolean flush) throws Exception {
        this.logger.debug((Object)("Persisting: " + entity));
        return this.perform(entity, new Persist(), null, flush);
    }

    public Object merge(Object entity, Boolean flush) throws Exception {
        this.logger.debug((Object)("Merging: " + entity));
        return this.perform(entity, new Merge(), null, flush);
    }

    public Object find(String entityClass, Object id, Boolean flush) throws Exception {
        this.logger.debug((Object)String.format("Finding entity of class: %s with primary key: %s", entityClass, id));
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("entityClass", entityClass);
        parameters.put("id", id);
        return this.perform(id, new Find(), parameters, flush);
    }

    public Object detach(Object entity, Boolean flush) throws Exception {
        this.logger.debug((Object)("Detaching: " + entity));
        return this.perform(entity, new Detach(), null, flush);
    }

    Object perform(Object object, JPACommand command, Map<String, Object> parameters, Boolean flush) throws Exception {
        this.logger.debug((Object)String.format("Executing JPA command with message: %s, command: %s and parameters: %s", object, command, parameters));
        EntityManager entityManager = (EntityManager)JPAUtils.getTransactionalResource(this.entityManagerFactory);
        if (entityManager == null) {
            throw new IllegalStateException("Could not obtain an EntityManager");
        }
        return command.execute(entityManager, object, parameters, flush);
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }
}

