/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.mule.api.MuleException;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.jpa.JPAException;
import org.mule.transaction.TransactionCoordination;

public class JPAUtils {
    public static <T> T getTransactionalResource(EntityManagerFactory entityManagerFactory) {
        Transaction currentTx = TransactionCoordination.getInstance().getTransaction();
        if (currentTx != null) {
            if (currentTx.hasResource((Object)entityManagerFactory)) {
                return (T)currentTx.getResource((Object)entityManagerFactory);
            }
            EntityManager connectionResource = entityManagerFactory.createEntityManager();
            try {
                if (!currentTx.supports((Object)entityManagerFactory, (Object)connectionResource)) {
                    throw new TransactionException(CoreMessages.createStaticMessage((String)"Endpoint is transactional but transaction does not support it"));
                }
                currentTx.bindResource((Object)entityManagerFactory, (Object)connectionResource);
            }
            catch (MuleException ex) {
                throw new JPAException(ex);
            }
            return (T)connectionResource;
        }
        return (T)entityManagerFactory.createEntityManager();
    }
}

