/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jpa.command;

import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaQuery;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.module.jpa.JPAException;
import org.mule.module.jpa.command.JPACommand;

public class Query
implements JPACommand {
    protected transient Log logger = LogFactory.getLog(this.getClass());

    @Override
    public Object execute(EntityManager entityManager, Object payload, Map<String, Object> parameters, Boolean flush) throws Exception {
        List result;
        Object queryParameters = parameters.get("queryParameters");
        if (queryParameters instanceof CriteriaQuery) {
            this.logger.debug((Object)("Executing CriteriaQuery: " + queryParameters));
            result = entityManager.createQuery((CriteriaQuery)queryParameters).getResultList();
        } else if (parameters.containsKey("namedQuery")) {
            this.logger.debug((Object)("Executing Named Query: " + parameters.get("namedQuery")));
            javax.persistence.Query query = entityManager.createNamedQuery((String)parameters.get("namedQuery"));
            if (queryParameters != null) {
                this.setParameters(queryParameters, query);
            }
            result = query.getResultList();
        } else if (parameters.containsKey("statement")) {
            this.logger.debug((Object)("Executing JPQL statement: " + parameters.get("statement")));
            javax.persistence.Query query = entityManager.createQuery((String)parameters.get("statement"));
            if (queryParameters != null) {
                this.setParameters(queryParameters, query);
            }
            result = query.getResultList();
        } else {
            throw new JPAException("Couldn't resolve query from either the query parameters or the statement attribute");
        }
        if (flush.booleanValue()) {
            entityManager.flush();
        }
        return result;
    }

    void setParameters(Object entity, javax.persistence.Query query) {
        if (entity instanceof Map) {
            Map parameters = (Map)entity;
            for (String key : parameters.keySet()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)String.format("Setting query parameter %s to %s", key, parameters.get(key)));
                }
                query.setParameter(key, parameters.get(key));
            }
        } else if (entity instanceof List) {
            List parameters = (List)entity;
            for (int i = 0; i < parameters.size(); ++i) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)String.format("Setting query parameter index %d to %s", i + 1, parameters.get(i)));
                }
                query.setParameter(i + 1, parameters.get(i));
            }
        } else {
            this.logger.warn((Object)"Payload should be a Map of parameters, List of parameters or null when using JPA-QL or named queries");
        }
    }
}

