/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jpa;

import java.lang.reflect.Field;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.expression.RequiredValueException;
import org.mule.api.registry.InjectProcessor;
import org.mule.config.i18n.AnnotationsMessages;
import org.mule.module.jpa.JPAException;
import org.mule.module.jpa.MuleEntityManager;

public class PersistenceContextProcessor
implements InjectProcessor,
MuleContextAware {
    protected final transient Log logger = LogFactory.getLog(PersistenceContextProcessor.class);
    MuleContext muleContext;

    public Object process(Object object) {
        Field[] fields;
        try {
            fields = object.getClass().getDeclaredFields();
        }
        catch (NoClassDefFoundError e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.warn((Object)e.toString());
            }
            return object;
        }
        for (Field field : fields) {
            if (!field.isAnnotationPresent(PersistenceContext.class)) continue;
            field.setAccessible(true);
            try {
                if (field.get(object) == null) {
                    EntityManagerFactory factory = (EntityManagerFactory)this.muleContext.getRegistry().lookupObject(EntityManagerFactory.class);
                    if (factory == null) {
                        throw new JPAException("Couldn't find an EntityManagerFactory in the registry to inject");
                    }
                    field.set(object, new MuleEntityManager(factory));
                    continue;
                }
                this.logger.warn((Object)"The PersistenceContext has already been injected");
            }
            catch (RequiredValueException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RequiredValueException(AnnotationsMessages.lookupFailedSeePreviousException((Object)object), (Throwable)e);
            }
        }
        return object;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

