/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttPersistable;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.internal.FileLock;
import org.eclipse.paho.client.mqttv3.internal.MqttPersistentData;

public class MqttDefaultFilePersistence
implements MqttClientPersistence {
    private File dataDir;
    private File clientDir = null;
    private FileLock fileLock = null;
    private static final String MESSAGE_FILE_EXTENSION = ".msg";
    private static final String MESSAGE_BACKUP_FILE_EXTENSION = ".bup";
    private static final String LOCK_FILENAME = ".lck";
    private static final FilenameFilter FILE_FILTER = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return name.endsWith(MqttDefaultFilePersistence.MESSAGE_FILE_EXTENSION);
        }
    };

    public MqttDefaultFilePersistence() throws MqttPersistenceException {
        this(System.getProperty("user.dir"));
    }

    public MqttDefaultFilePersistence(String directory) throws MqttPersistenceException {
        this.dataDir = new File(directory);
    }

    public void open(String clientId, String theConnection) throws MqttPersistenceException {
        char c;
        int i;
        if (this.dataDir.exists() && !this.dataDir.isDirectory()) {
            throw new MqttPersistenceException();
        }
        if (!this.dataDir.exists() ? !this.dataDir.mkdirs() : !this.dataDir.canWrite()) {
            throw new MqttPersistenceException();
        }
        StringBuffer keyBuffer = new StringBuffer();
        for (i = 0; i < clientId.length(); ++i) {
            c = clientId.charAt(i);
            if (!this.isSafeChar(c)) continue;
            keyBuffer.append(c);
        }
        keyBuffer.append("-");
        for (i = 0; i < theConnection.length(); ++i) {
            c = theConnection.charAt(i);
            if (!this.isSafeChar(c)) continue;
            keyBuffer.append(c);
        }
        String key = keyBuffer.toString();
        this.clientDir = new File(this.dataDir, key);
        if (!this.clientDir.exists()) {
            this.clientDir.mkdir();
        }
        try {
            this.fileLock = new FileLock(new File(this.clientDir, LOCK_FILENAME));
        }
        catch (Exception e) {
            throw new MqttPersistenceException(32200);
        }
        this.restoreBackups(this.clientDir);
    }

    private void checkIsOpen() throws MqttPersistenceException {
        if (this.clientDir == null) {
            throw new MqttPersistenceException();
        }
    }

    public void close() throws MqttPersistenceException {
        this.checkIsOpen();
        if (this.fileLock != null) {
            this.fileLock.release();
            File lockFile = new File(this.clientDir, LOCK_FILENAME);
            if (lockFile.exists()) {
                lockFile.delete();
            }
        }
        if (this.clientDir.listFiles(FILE_FILTER).length == 0) {
            this.clientDir.delete();
        }
        this.clientDir = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void put(String key, MqttPersistable message) throws MqttPersistenceException {
        boolean result;
        this.checkIsOpen();
        File file = new File(this.clientDir, key + MESSAGE_FILE_EXTENSION);
        File backupFile = new File(this.clientDir, key + MESSAGE_FILE_EXTENSION + MESSAGE_BACKUP_FILE_EXTENSION);
        if (file.exists() && !(result = file.renameTo(backupFile))) {
            backupFile.delete();
            file.renameTo(backupFile);
        }
        try {
            block6: {
                try {
                    FileOutputStream fos = new FileOutputStream(file);
                    fos.write(message.getHeaderBytes(), message.getHeaderOffset(), message.getHeaderLength());
                    if (message.getPayloadBytes() != null) {
                        fos.write(message.getPayloadBytes(), message.getPayloadOffset(), message.getPayloadLength());
                    }
                    fos.getFD().sync();
                    fos.close();
                    if (!backupFile.exists()) break block6;
                    backupFile.delete();
                }
                catch (IOException ex) {
                    throw new MqttPersistenceException(ex);
                }
            }
            Object var7_8 = null;
            if (!backupFile.exists()) return;
            boolean result2 = backupFile.renameTo(file);
            if (result2) return;
            file.delete();
            backupFile.renameTo(file);
            return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (!backupFile.exists()) throw throwable;
            boolean result2 = backupFile.renameTo(file);
            if (result2) throw throwable;
            file.delete();
            backupFile.renameTo(file);
            throw throwable;
        }
    }

    public MqttPersistable get(String key) throws MqttPersistenceException {
        MqttPersistentData result;
        this.checkIsOpen();
        try {
            File file = new File(this.clientDir, key + MESSAGE_FILE_EXTENSION);
            FileInputStream fis = new FileInputStream(file);
            int size = fis.available();
            byte[] data = new byte[size];
            for (int read = 0; read < size; read += fis.read(data, read, size - read)) {
            }
            fis.close();
            result = new MqttPersistentData(key, data, 0, data.length, null, 0, 0);
        }
        catch (IOException ex) {
            throw new MqttPersistenceException(ex);
        }
        return result;
    }

    public void remove(String key) throws MqttPersistenceException {
        this.checkIsOpen();
        File file = new File(this.clientDir, key + MESSAGE_FILE_EXTENSION);
        if (file.exists()) {
            file.delete();
        }
    }

    public Enumeration keys() throws MqttPersistenceException {
        this.checkIsOpen();
        File[] files = this.getFiles();
        Vector<String> result = new Vector<String>(files.length);
        for (int i = 0; i < files.length; ++i) {
            String filename = files[i].getName();
            String key = filename.substring(0, filename.length() - MESSAGE_FILE_EXTENSION.length());
            result.addElement(key);
        }
        return result.elements();
    }

    private File[] getFiles() throws MqttPersistenceException {
        this.checkIsOpen();
        File[] files = this.clientDir.listFiles(FILE_FILTER);
        if (files == null) {
            throw new MqttPersistenceException();
        }
        return files;
    }

    private boolean isSafeChar(char c) {
        return Character.isJavaIdentifierPart(c) || c == '-';
    }

    private void restoreBackups(File dir) throws MqttPersistenceException {
        File[] files = dir.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.getName().endsWith(MqttDefaultFilePersistence.MESSAGE_BACKUP_FILE_EXTENSION);
            }
        });
        for (int i = 0; i < files.length; ++i) {
            File originalFile = new File(dir, files[i].getName().substring(0, files[i].getName().length() - MESSAGE_BACKUP_FILE_EXTENSION.length()));
            boolean result = files[i].renameTo(originalFile);
            if (result) continue;
            originalFile.delete();
            files[i].renameTo(originalFile);
        }
    }

    public boolean containsKey(String key) throws MqttPersistenceException {
        this.checkIsOpen();
        File file = new File(this.clientDir, key + MESSAGE_FILE_EXTENSION);
        return file.exists();
    }

    public void clear() throws MqttPersistenceException {
        this.checkIsOpen();
        File[] files = this.getFiles();
        for (int i = 0; i < files.length; ++i) {
            files[i].delete();
        }
    }
}

