/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.io.IOException;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.internal.ClientState;
import org.eclipse.paho.client.mqttv3.internal.CommsCallback;
import org.eclipse.paho.client.mqttv3.internal.CommsReceiver;
import org.eclipse.paho.client.mqttv3.internal.CommsSender;
import org.eclipse.paho.client.mqttv3.internal.CommsTokenStore;
import org.eclipse.paho.client.mqttv3.internal.DestinationProvider;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import org.eclipse.paho.client.mqttv3.internal.MqttDeliveryTokenImpl;
import org.eclipse.paho.client.mqttv3.internal.NetworkModule;
import org.eclipse.paho.client.mqttv3.internal.trace.Trace;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttConnack;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttConnect;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttDisconnect;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;

public class ClientComms {
    private DestinationProvider destinationProvider;
    private NetworkModule networkModule;
    private boolean connected;
    private CommsReceiver receiver;
    private CommsSender sender;
    private CommsCallback callback;
    private ClientState clientState;
    private MqttClientPersistence persistence;
    private CommsTokenStore tokenStore;
    private boolean disconnecting = false;
    private Thread disconnectThread = null;
    private int connectionTimeoutSecs;
    private Trace trace;

    public ClientComms(DestinationProvider destinationProvider, MqttClientPersistence persistence, Trace trace) throws MqttException {
        this.trace = trace;
        this.callback = new CommsCallback(trace, this);
        this.connected = false;
        this.tokenStore = new CommsTokenStore(this.trace);
        this.destinationProvider = destinationProvider;
        this.clientState = new ClientState(trace, persistence, this.tokenStore, this.callback);
        this.persistence = persistence;
    }

    private MqttDeliveryTokenImpl internalSend(MqttWireMessage message) throws MqttException {
        MqttDeliveryTokenImpl token = null;
        if (this.trace.isOn()) {
            this.trace.trace((byte)1, 200, new Object[]{message.getClass().getName()});
        }
        if (!this.disconnecting && this.connected) {
            token = this.clientState.send(message);
            if (message instanceof MqttPublish) {
                try {
                    this.clientState.incrementWaitingTokens();
                    token.waitUntilSent();
                }
                catch (MqttException me) {
                    if (this.trace.isOn()) {
                        this.trace.trace((byte)1, 202, null, me);
                    }
                    this.clientState.undo((MqttPublish)message);
                    throw me;
                }
                finally {
                    this.clientState.decrementWaitingTokens();
                }
            }
        } else {
            this.trace.trace((byte)1, 208, new Object[]{new Boolean(this.disconnecting), new Boolean(this.connected)});
            throw ExceptionHelper.createMqttException(32104);
        }
        return token;
    }

    public void sendAndWait(MqttWireMessage message) throws MqttException {
        this.internalSend(message).waitForCompletion(this.connectionTimeoutSecs * 1000);
    }

    public MqttDeliveryTokenImpl sendNoWait(MqttWireMessage message) throws MqttException {
        return this.internalSend(message);
    }

    public MqttConnack connect(MqttConnect connect, int connectionTimeoutSecs, long keepAliveSecs, boolean cleanSession) throws MqttException {
        if (!this.connected) {
            this.disconnecting = false;
            this.connectionTimeoutSecs = connectionTimeoutSecs;
            this.clientState.setKeepAliveSecs(keepAliveSecs);
            this.clientState.setCleanSession(cleanSession);
            try {
                this.networkModule.start();
                this.receiver = new CommsReceiver(this.trace, this, this.clientState, this.tokenStore, this.networkModule.getInputStream());
                this.receiver.start();
                this.sender = new CommsSender(this.trace, this, this.clientState, this.tokenStore, this.networkModule.getOutputStream());
                this.sender.start();
            }
            catch (IOException ex) {
                this.trace.trace((byte)1, 209, null, ex);
                this.persistence.close();
                throw ExceptionHelper.createMqttException(ex);
            }
            catch (MqttException ex) {
                this.trace.trace((byte)1, 212, null, ex);
                this.persistence.close();
                throw ex;
            }
            this.callback.start();
            try {
                MqttDeliveryTokenImpl token = this.clientState.send(connect);
                MqttWireMessage ack = token.waitForResponse(connectionTimeoutSecs * 1000);
                if (ack == null) {
                    this.trace.trace((byte)1, 203);
                    this.persistence.close();
                    throw ExceptionHelper.createMqttException(32000);
                }
                if (ack instanceof MqttConnack) {
                    MqttConnack cack = (MqttConnack)ack;
                    if (cack.getReturnCode() != 0) {
                        this.trace.trace((byte)1, 204, new Object[]{new Integer(cack.getReturnCode())});
                        this.persistence.close();
                        this.disconnectThread = Thread.currentThread();
                        this.shutdownConnection(null);
                        throw ExceptionHelper.createMqttException(cack.getReturnCode());
                    }
                    this.connected = true;
                    return (MqttConnack)ack;
                }
                this.trace.trace((byte)1, 205, new Object[]{ack});
                this.persistence.close();
                throw ExceptionHelper.createMqttException(6);
            }
            catch (MqttException ex) {
                this.trace.trace((byte)1, 206, null, ex);
                this.shutdownConnection(null);
                throw ex;
            }
        }
        this.trace.trace((byte)1, 207);
        throw ExceptionHelper.createMqttException(32100);
    }

    public void shutdownConnection(MqttException reason) {
        if (this.disconnectThread != null && !this.disconnectThread.equals(Thread.currentThread())) {
            return;
        }
        if (this.trace.isOn()) {
            this.trace.trace((byte)1, 201, new Object[]{new Boolean(this.disconnecting)}, reason);
        }
        if (!this.disconnecting) {
            boolean wasConnected = this.connected;
            this.disconnecting = true;
            this.clientState.disconnecting(reason);
            try {
                this.callback.stop();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            try {
                this.networkModule.stop();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            try {
                this.receiver.stop();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.clientState.disconnected(reason);
            try {
                this.sender.stop();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.connected = false;
            if (wasConnected && reason != null) {
                this.callback.connectionLost(reason);
            }
        } else {
            this.connected = false;
        }
    }

    public void disconnect(MqttDisconnect disconnect, long quiesceTimeout) throws MqttException {
        block6: {
            if (this.connected) {
                if (Thread.currentThread() == this.callback.getThread()) {
                    this.trace.trace((byte)1, 210);
                    throw ExceptionHelper.createMqttException(32107);
                }
                this.clientState.quiesce(quiesceTimeout);
                this.receiver.setDisconnecting(true);
                try {
                    this.disconnectThread = Thread.currentThread();
                    MqttDeliveryTokenImpl token = this.sendNoWait(disconnect);
                    token.waitUntilSent();
                    Object var6_5 = null;
                    this.shutdownConnection(null);
                    this.disconnectThread = null;
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.shutdownConnection(null);
                    this.disconnectThread = null;
                    throw throwable;
                }
            }
            this.trace.trace((byte)1, 211);
            throw ExceptionHelper.createMqttException(32101);
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setCallback(MqttCallback mqttCallback) {
        this.callback.setCallback(mqttCallback);
    }

    protected MqttTopic getTopic(String topic) {
        return this.destinationProvider.getTopic(topic);
    }

    public void setNetworkModule(NetworkModule networkModule) {
        this.networkModule = networkModule;
    }

    public MqttDeliveryToken[] getPendingDeliveryTokens() {
        return this.tokenStore.getOutstandingTokens();
    }

    protected void deliveryComplete(MqttPublish msg) throws MqttPersistenceException {
        this.clientState.deliveryComplete(msg);
    }
}

