/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import org.eclipse.paho.client.mqttv3.internal.trace.Trace;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;

public class MqttDeliveryTokenImpl
implements MqttDeliveryToken {
    private Object responseLock = new Object();
    private Object sentLock = new Object();
    private MqttMessage message;
    private MqttWireMessage response = null;
    private MqttException exception = null;
    private boolean sent = false;
    private boolean completed = false;
    private int msgId = 0;
    private Trace trace;

    MqttDeliveryTokenImpl(Trace trace) {
        this.message = null;
        this.trace = trace;
    }

    MqttDeliveryTokenImpl(Trace trace, MqttPublish send) {
        this.trace = trace;
        this.message = send.getMessage();
        this.msgId = send.getMessageId();
    }

    public void waitForCompletion(long timeout) throws MqttException {
        MqttWireMessage response = this.waitForResponse(timeout);
        if (response == null && !this.completed) {
            if (this.trace.isOn()) {
                this.trace.trace((byte)1, 406, new Object[]{new Long(timeout)});
            }
            throw new MqttException(32000);
        }
    }

    public void waitForCompletion() throws MqttException {
        this.waitForCompletion(-1L);
    }

    protected MqttWireMessage waitForResponse() throws MqttException {
        return this.waitForResponse(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MqttWireMessage waitForResponse(long timeout) throws MqttException {
        Object object = this.responseLock;
        synchronized (object) {
            if (this.trace.isOn()) {
                this.trace.trace((byte)1, 400, new Object[]{this, new Long(timeout), new Boolean(this.sent), new Boolean(this.completed), this.exception == null ? "false" : "true", this.response}, this.exception);
            }
            if (this.completed) {
                return this.response;
            }
            if (this.exception == null) {
                try {
                    if (timeout == -1L) {
                        this.responseLock.wait();
                    } else {
                        this.responseLock.wait(timeout);
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (!this.completed && this.exception != null) {
                MqttException e = this.exception;
                this.exception = null;
                this.trace.trace((byte)1, 401, null, this.exception);
                throw e;
            }
        }
        this.trace.trace((byte)1, 402, new Object[]{this.response});
        return this.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitUntilSent() throws MqttException {
        Object object = this.sentLock;
        synchronized (object) {
            Object object2 = this.responseLock;
            synchronized (object2) {
                if (this.exception != null) {
                    throw this.exception;
                }
            }
            if (!this.sent) {
                try {
                    this.sentLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.sent) {
                if (this.exception == null) {
                    throw ExceptionHelper.createMqttException(6);
                }
                throw this.exception;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifySent() {
        this.trace.trace((byte)1, 403, new Object[]{this});
        Object object = this.responseLock;
        synchronized (object) {
            this.response = null;
            this.completed = false;
        }
        object = this.sentLock;
        synchronized (object) {
            this.sent = true;
            this.sentLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyReceived(MqttWireMessage msg) {
        this.trace.trace((byte)1, 404, new Object[]{this, msg});
        Object object = this.responseLock;
        synchronized (object) {
            if (msg instanceof MqttAck) {
                this.message = null;
            }
            this.response = msg;
            this.completed = true;
            this.responseLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyException(MqttException exception) {
        this.trace.trace((byte)1, 405, new Object[]{this}, exception);
        Object object = this.responseLock;
        synchronized (object) {
            this.exception = exception;
            this.responseLock.notifyAll();
        }
        object = this.sentLock;
        synchronized (object) {
            this.sentLock.notifyAll();
        }
    }

    public MqttMessage getMessage() throws MqttException {
        return this.message;
    }

    public boolean isComplete() {
        return this.completed;
    }

    public int getMessageId() {
        return this.msgId;
    }
}

