/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import javax.net.SocketFactory;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import org.eclipse.paho.client.mqttv3.internal.NetworkModule;
import org.eclipse.paho.client.mqttv3.internal.trace.Trace;

public class TCPNetworkModule
implements NetworkModule {
    protected Socket socket;
    private SocketFactory factory;
    private String host;
    private int port;
    protected Trace trace;

    public TCPNetworkModule(Trace trace, SocketFactory factory, String host, int port) {
        this.factory = factory;
        this.host = host;
        this.port = port;
        this.trace = trace;
    }

    public void start() throws IOException, MqttException {
        try {
            this.socket = this.factory.createSocket(this.host, this.port);
        }
        catch (ConnectException ex) {
            this.trace.trace((byte)1, 250, null, ex);
            throw ExceptionHelper.createMqttException(32103);
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    public void stop() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
    }
}

