/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.trace;

import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import org.eclipse.paho.client.mqttv3.internal.trace.TraceDestination;
import org.eclipse.paho.client.mqttv3.internal.trace.TracePoint;

public class Trace {
    public static final byte FINE = 1;
    public static final byte FINER = 2;
    public static final byte FINEST = 3;
    private static TraceDestination destination;
    private static short count;
    private short source;
    private String resource;
    private boolean on;

    public static synchronized Trace getTrace(String resource) {
        if (destination == null && ExceptionHelper.isClassAvailable("java.io.File")) {
            try {
                destination = (TraceDestination)Class.forName("org.eclipse.paho.client.mqttv3.internal.trace.TraceFileDestination").newInstance();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Trace trace = new Trace(count, resource);
        count = (short)(count + 1);
        return trace;
    }

    private Trace(short source, String resource) {
        this.source = source;
        this.resource = resource;
        this.on = destination != null && destination.isEnabled(this.resource);
    }

    public boolean isOn() {
        return this.on;
    }

    public void traceEntry(byte level, int id) {
        if (this.on) {
            destination.write(new TracePoint(this.source, 1, level, id, null, null));
        }
    }

    public void traceExit(byte level, int id) {
        if (this.on) {
            destination.write(new TracePoint(this.source, 2, level, id, null, null));
        }
    }

    public void traceBreak(byte level, int id) {
        if (this.on) {
            destination.write(new TracePoint(this.source, 3, level, id, null, null));
        }
    }

    public void traceCatch(byte level, int id, Throwable throwable) {
        if (this.on) {
            destination.write(new TracePoint(this.source, 4, level, id, throwable, null));
        }
    }

    public void trace(byte level, int id) {
        if (this.on) {
            destination.write(new TracePoint(this.source, 5, level, id, null, null));
        }
    }

    public void trace(byte level, int id, Object[] inserts) {
        if (this.on) {
            destination.write(new TracePoint(this.source, 5, level, id, null, inserts));
        }
    }

    public void trace(byte level, int id, Object[] inserts, Throwable throwable) {
        if (this.on) {
            destination.write(new TracePoint(this.source, 5, level, id, throwable, inserts));
        }
    }

    static {
        count = 0;
    }
}

