/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.trace;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.paho.client.mqttv3.internal.trace.TraceDestination;
import org.eclipse.paho.client.mqttv3.internal.trace.TracePoint;

public class TraceFileDestination
implements TraceDestination {
    private boolean enabled = false;
    private DataOutputStream dos;
    private ByteArrayOutputStream buffer;
    private FileOutputStream out;
    private File tracePropertiesFile;
    private File traceDirectory;
    private int fileCount;
    private int maxFileSize;
    private int fileIndex = 0;
    private int currentFileSize = 0;
    private Properties traceProperties = new Properties();
    private long tracePropertiesUpdate = 0L;

    public TraceFileDestination() {
        String tracePropertiesFilename = System.getProperty("org.eclipse.paho.client.mqttv3.trace");
        this.tracePropertiesFile = tracePropertiesFilename == null ? new File(System.getProperty("user.dir"), "mqtt-trace.properties") : new File(tracePropertiesFilename);
        this.updateTraceProperties();
    }

    private boolean updateTraceProperties() {
        if (this.tracePropertiesFile.exists()) {
            if (this.tracePropertiesFile.lastModified() != this.tracePropertiesUpdate) {
                try {
                    this.traceProperties.load(new FileInputStream(this.tracePropertiesFile));
                    this.tracePropertiesUpdate = this.tracePropertiesFile.lastModified();
                }
                catch (Exception e) {
                    this.traceProperties.clear();
                    this.tracePropertiesUpdate = 0L;
                    this.enabled = false;
                    return false;
                }
                String directory = this.traceProperties.getProperty("org.eclipse.paho.client.mqttv3.trace.outputName", System.getProperty("user.dir"));
                this.traceDirectory = new File(directory);
                if (!this.traceDirectory.exists()) {
                    this.traceProperties.clear();
                    this.tracePropertiesUpdate = 0L;
                    this.enabled = false;
                    return false;
                }
                this.fileCount = Integer.parseInt(this.traceProperties.getProperty("org.eclipse.paho.client.mqttv3.trace.count", "1"));
                this.maxFileSize = Integer.parseInt(this.traceProperties.getProperty("org.eclipse.paho.client.mqttv3.trace.limit", "5000000"));
                this.initialiseFile();
                if (this.out == null) {
                    this.traceProperties.clear();
                    this.tracePropertiesUpdate = 0L;
                    this.enabled = false;
                    return false;
                }
                this.buffer = new ByteArrayOutputStream();
                this.dos = new DataOutputStream(this.buffer);
                this.enabled = true;
                return true;
            }
            return this.enabled;
        }
        this.traceProperties.clear();
        this.tracePropertiesUpdate = 0L;
        this.enabled = false;
        return false;
    }

    public boolean isEnabled(String resource) {
        return this.enabled && ("on".equalsIgnoreCase(this.traceProperties.getProperty("org.eclipse.paho.client.mqttv3.trace.client.*.status")) || "on".equalsIgnoreCase(this.traceProperties.getProperty("org.eclipse.paho.client.mqttv3.trace.client." + resource + ".status")));
    }

    public void initialiseFile() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.out = null;
        }
        this.currentFileSize = 0;
        File traceFile = new File(this.traceDirectory, "mqtt-" + this.fileIndex + ".trc");
        if (traceFile.exists()) {
            traceFile.delete();
        }
        try {
            this.out = new FileOutputStream(traceFile);
        }
        catch (FileNotFoundException e) {
            this.enabled = false;
            this.out = null;
        }
    }

    public synchronized void write(TracePoint point) {
        try {
            this.dos.writeShort(point.source);
            this.dos.writeLong(point.timestamp);
            byte meta = point.type;
            if (point.inserts != null && point.inserts.length > 0) {
                meta = (byte)(meta | 0x20);
            }
            if (point.throwable != null) {
                meta = (byte)(meta | 0x40);
            }
            this.dos.writeByte(meta);
            this.dos.writeShort(point.id);
            this.dos.writeUTF(point.threadName);
            if (point.inserts != null && point.inserts.length > 0) {
                this.dos.writeShort(point.inserts.length);
                for (int i = 0; i < point.inserts.length; ++i) {
                    if (point.inserts[i] != null) {
                        this.dos.writeUTF(point.inserts[i].toString());
                        continue;
                    }
                    this.dos.writeUTF("null");
                }
            }
            if (point.throwable != null) {
                StackTraceElement[] stack = point.throwable.getStackTrace();
                this.dos.writeShort(stack.length + 1);
                this.dos.writeUTF(point.throwable.toString());
                for (int i = 0; i < stack.length; ++i) {
                    this.dos.writeUTF(stack[i].toString());
                }
            }
            if (this.fileCount > 1 && this.currentFileSize + this.buffer.size() > this.maxFileSize) {
                ++this.fileIndex;
                if (this.fileIndex == this.fileCount) {
                    this.fileIndex = 0;
                }
                this.initialiseFile();
            }
            if (this.out != null) {
                this.currentFileSize += this.buffer.size();
                this.buffer.writeTo(this.out);
                this.out.flush();
            }
            this.buffer.reset();
        }
        catch (Exception e) {
            this.enabled = false;
        }
    }
}

