/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.wire;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;

public class MqttInputStream
extends InputStream {
    private DataInputStream in;

    public MqttInputStream(InputStream in) {
        this.in = new DataInputStream(in);
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
    }

    public MqttWireMessage readMqttWireMessage() throws IOException, MqttException {
        ByteArrayOutputStream bais = new ByteArrayOutputStream();
        byte first = this.in.readByte();
        byte type = (byte)(first >>> 4 & 0xF);
        if (type < 1 || type > 14) {
            throw ExceptionHelper.createMqttException(32108);
        }
        long remLen = MqttWireMessage.readMBI(this.in).getValue();
        bais.write(first);
        bais.write(MqttWireMessage.encodeMBI(remLen));
        byte[] packet = new byte[(int)((long)bais.size() + remLen)];
        this.in.readFully(packet, bais.size(), packet.length - bais.size());
        byte[] header = bais.toByteArray();
        System.arraycopy(header, 0, packet, 0, header.length);
        MqttWireMessage message = MqttWireMessage.createWireMessage(packet);
        return message;
    }
}

