/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.wire;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.internal.wire.CountingInputStream;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPersistableWireMessage;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttReceivedMessage;

public class MqttPublish
extends MqttPersistableWireMessage {
    public static final byte DESTINATION_TYPE_TOPIC = 0;
    private MqttMessage message;
    private String topicName;
    private byte[] encodedPayload = null;

    public MqttPublish(String name, MqttMessage message) {
        super((byte)3);
        this.topicName = name;
        this.message = message;
    }

    public MqttPublish(byte info, byte[] data) throws MqttException, IOException {
        super((byte)3);
        this.message = new MqttReceivedMessage();
        this.message.setQos(info >> 1 & 3);
        if ((info & 1) == 1) {
            this.message.setRetained(true);
        }
        if ((info & 8) == 8) {
            ((MqttReceivedMessage)this.message).setDuplicate(true);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        CountingInputStream counter = new CountingInputStream(bais);
        DataInputStream dis = new DataInputStream(counter);
        this.topicName = dis.readUTF();
        if (this.message.getQos() > 0) {
            this.msgId = dis.readUnsignedShort();
        }
        dis.close();
        byte[] payload = new byte[data.length - counter.getCounter()];
        dis.readFully(payload);
        this.message.setPayload(payload);
    }

    protected byte getMessageInfo() {
        byte info = (byte)(this.message.getQos() << 1);
        if (this.message.isRetained()) {
            info = (byte)(info | 1);
        }
        if (this.message.isDuplicate()) {
            info = (byte)(info | 8);
        }
        return info;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public MqttMessage getMessage() {
        return this.message;
    }

    protected static byte[] encodePayload(MqttMessage message) throws MqttException {
        return message.getPayload();
    }

    public byte[] getPayload() throws MqttException {
        if (this.encodedPayload == null) {
            this.encodedPayload = MqttPublish.encodePayload(this.message);
        }
        return this.encodedPayload;
    }

    public int getPayloadLength() {
        int length = 0;
        try {
            length = this.getPayload().length;
        }
        catch (MqttException mqttException) {
            // empty catch block
        }
        return length;
    }

    public void setMessageId(int msgId) {
        super.setMessageId(msgId);
        if (this.message instanceof MqttReceivedMessage) {
            ((MqttReceivedMessage)this.message).setMessageId(msgId);
        }
    }

    protected byte[] getVariableHeader() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeUTF(this.topicName);
            if (this.message.getQos() > 0) {
                dos.writeShort(this.msgId);
            }
            dos.flush();
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw new MqttException(ex);
        }
    }

    public boolean isMessageIdRequired() {
        return true;
    }
}

