
package org.mule.modules.mqtt.connectivity;

import javax.annotation.Generated;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.modules.mqtt.adapters.MqttConnectorConnectionIdentifierAdapter;
import org.mule.modules.mqtt.connection.ConnectionManager;
import org.mule.modules.mqtt.process.ManagedConnectionProcessInterceptor;
import org.mule.modules.mqtt.process.ProcessCallback;
import org.mule.modules.mqtt.process.ProcessCallbackProcessInterceptor;
import org.mule.modules.mqtt.process.ProcessInterceptor;
import org.mule.modules.mqtt.process.ProcessTemplate;
import org.mule.modules.mqtt.process.RetryProcessInterceptor;

@Generated(value = "Mule DevKit Version 3.4.0", date = "2013-05-30T07:10:26-03:00", comments = "Build 3.4.0.1555.8df15c1")
public class ManagedConnectionProcessTemplate<P >implements ProcessTemplate<P, MqttConnectorConnectionIdentifierAdapter>
{

    private final ProcessInterceptor<P, MqttConnectorConnectionIdentifierAdapter> processInterceptor;

    public ManagedConnectionProcessTemplate(ConnectionManager<MqttConnectorConnectionKey, MqttConnectorConnectionIdentifierAdapter> connectionManager, MuleContext muleContext) {
        ProcessInterceptor<P, MqttConnectorConnectionIdentifierAdapter> processCallbackProcessInterceptor = new ProcessCallbackProcessInterceptor<P, MqttConnectorConnectionIdentifierAdapter>();
        ProcessInterceptor<P, MqttConnectorConnectionIdentifierAdapter> managedConnectionProcessInterceptor = new ManagedConnectionProcessInterceptor<P>(processCallbackProcessInterceptor, connectionManager, muleContext);
        ProcessInterceptor<P, MqttConnectorConnectionIdentifierAdapter> retryProcessInterceptor = new RetryProcessInterceptor<P, MqttConnectorConnectionIdentifierAdapter>(managedConnectionProcessInterceptor, muleContext, connectionManager.getRetryPolicyTemplate());
        processInterceptor = retryProcessInterceptor;
    }

    public P execute(ProcessCallback<P, MqttConnectorConnectionIdentifierAdapter> processCallback, MessageProcessor messageProcessor, MuleEvent event)
        throws Exception
    {
        return processInterceptor.execute(processCallback, null, messageProcessor, event);
    }

    public P execute(ProcessCallback<P, MqttConnectorConnectionIdentifierAdapter> processCallback, Filter filter, MuleMessage message)
        throws Exception
    {
        return processInterceptor.execute(processCallback, null, filter, message);
    }

}
