
package org.mule.modules.mqtt.connectivity;

import javax.annotation.Generated;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.mule.api.MuleContext;
import org.mule.api.config.MuleProperties;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.config.PoolingProfile;
import org.mule.modules.mqtt.MqttConnector;
import org.mule.modules.mqtt.adapters.MqttConnectorConnectionIdentifierAdapter;
import org.mule.modules.mqtt.basic.Capabilities;
import org.mule.modules.mqtt.basic.Capability;
import org.mule.modules.mqtt.basic.MetadataAware;
import org.mule.modules.mqtt.connection.ConnectionManager;
import org.mule.modules.mqtt.process.ProcessAdapter;
import org.mule.modules.mqtt.process.ProcessTemplate;


/**
 * A {@code MqttConnectorConnectionManager} is a wrapper around {@link MqttConnector } that adds connection management capabilities to the pojo.
 * 
 */
@Generated(value = "Mule DevKit Version 3.4.0", date = "2013-05-30T07:10:26-03:00", comments = "Build 3.4.0.1555.8df15c1")
public class MqttConnectorConnectionManager implements MuleContextAware, Initialisable, Capabilities, MetadataAware, ConnectionManager<MqttConnectorConnectionKey, MqttConnectorConnectionIdentifierAdapter> , ProcessAdapter<MqttConnectorConnectionIdentifierAdapter>
{

    /**
     * 
     */
    private String clientId;
    private String brokerServerUri;
    private boolean cleanSession;
    private String username;
    private String password;
    private int connectionTimeout;
    private String lwtTopicName;
    private String lwtMessage;
    private int lwtQos;
    private boolean lwtRetained;
    private int keepAliveInterval;
    private String persistenceLocation;
    /**
     * Mule Context
     * 
     */
    protected MuleContext muleContext;
    /**
     * Flow Construct
     * 
     */
    protected FlowConstruct flowConstruct;
    /**
     * Connector Pool
     * 
     */
    private GenericKeyedObjectPool connectionPool;
    protected PoolingProfile connectionPoolingProfile;
    protected RetryPolicyTemplate retryPolicyTemplate;
    private final static String MODULE_NAME = "MQTT";
    private final static String MODULE_VERSION = "1.0";
    private final static String DEVKIT_VERSION = "3.4.0";
    private final static String DEVKIT_BUILD = "3.4.0.1555.8df15c1";

    /**
     * Sets brokerServerUri
     * 
     * @param value Value to set
     */
    public void setBrokerServerUri(String value) {
        this.brokerServerUri = value;
    }

    /**
     * Retrieves brokerServerUri
     * 
     */
    public String getBrokerServerUri() {
        return this.brokerServerUri;
    }

    /**
     * Sets cleanSession
     * 
     * @param value Value to set
     */
    public void setCleanSession(boolean value) {
        this.cleanSession = value;
    }

    /**
     * Retrieves cleanSession
     * 
     */
    public boolean getCleanSession() {
        return this.cleanSession;
    }

    /**
     * Sets username
     * 
     * @param value Value to set
     */
    public void setUsername(String value) {
        this.username = value;
    }

    /**
     * Retrieves username
     * 
     */
    public String getUsername() {
        return this.username;
    }

    /**
     * Sets password
     * 
     * @param value Value to set
     */
    public void setPassword(String value) {
        this.password = value;
    }

    /**
     * Retrieves password
     * 
     */
    public String getPassword() {
        return this.password;
    }

    /**
     * Sets connectionTimeout
     * 
     * @param value Value to set
     */
    public void setConnectionTimeout(int value) {
        this.connectionTimeout = value;
    }

    /**
     * Retrieves connectionTimeout
     * 
     */
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    /**
     * Sets lwtTopicName
     * 
     * @param value Value to set
     */
    public void setLwtTopicName(String value) {
        this.lwtTopicName = value;
    }

    /**
     * Retrieves lwtTopicName
     * 
     */
    public String getLwtTopicName() {
        return this.lwtTopicName;
    }

    /**
     * Sets lwtMessage
     * 
     * @param value Value to set
     */
    public void setLwtMessage(String value) {
        this.lwtMessage = value;
    }

    /**
     * Retrieves lwtMessage
     * 
     */
    public String getLwtMessage() {
        return this.lwtMessage;
    }

    /**
     * Sets lwtQos
     * 
     * @param value Value to set
     */
    public void setLwtQos(int value) {
        this.lwtQos = value;
    }

    /**
     * Retrieves lwtQos
     * 
     */
    public int getLwtQos() {
        return this.lwtQos;
    }

    /**
     * Sets lwtRetained
     * 
     * @param value Value to set
     */
    public void setLwtRetained(boolean value) {
        this.lwtRetained = value;
    }

    /**
     * Retrieves lwtRetained
     * 
     */
    public boolean getLwtRetained() {
        return this.lwtRetained;
    }

    /**
     * Sets keepAliveInterval
     * 
     * @param value Value to set
     */
    public void setKeepAliveInterval(int value) {
        this.keepAliveInterval = value;
    }

    /**
     * Retrieves keepAliveInterval
     * 
     */
    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    /**
     * Sets persistenceLocation
     * 
     * @param value Value to set
     */
    public void setPersistenceLocation(String value) {
        this.persistenceLocation = value;
    }

    /**
     * Retrieves persistenceLocation
     * 
     */
    public String getPersistenceLocation() {
        return this.persistenceLocation;
    }

    /**
     * Sets muleContext
     * 
     * @param value Value to set
     */
    public void setMuleContext(MuleContext value) {
        this.muleContext = value;
    }

    /**
     * Retrieves muleContext
     * 
     */
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    /**
     * Sets flowConstruct
     * 
     * @param value Value to set
     */
    public void setFlowConstruct(FlowConstruct value) {
        this.flowConstruct = value;
    }

    /**
     * Retrieves flowConstruct
     * 
     */
    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    /**
     * Sets connectionPoolingProfile
     * 
     * @param value Value to set
     */
    public void setConnectionPoolingProfile(PoolingProfile value) {
        this.connectionPoolingProfile = value;
    }

    /**
     * Retrieves connectionPoolingProfile
     * 
     */
    public PoolingProfile getConnectionPoolingProfile() {
        return this.connectionPoolingProfile;
    }

    /**
     * Sets retryPolicyTemplate
     * 
     * @param value Value to set
     */
    public void setRetryPolicyTemplate(RetryPolicyTemplate value) {
        this.retryPolicyTemplate = value;
    }

    /**
     * Retrieves retryPolicyTemplate
     * 
     */
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    /**
     * Sets clientId
     * 
     * @param value Value to set
     */
    public void setClientId(String value) {
        this.clientId = value;
    }

    /**
     * Retrieves clientId
     * 
     */
    public String getClientId() {
        return this.clientId;
    }

    public void initialise() {
        GenericKeyedObjectPool.Config config = new GenericKeyedObjectPool.Config();
        if (connectionPoolingProfile!= null) {
            config.maxIdle = connectionPoolingProfile.getMaxIdle();
            config.maxActive = connectionPoolingProfile.getMaxActive();
            config.maxWait = connectionPoolingProfile.getMaxWait();
            config.whenExhaustedAction = ((byte) connectionPoolingProfile.getExhaustedAction());
        }
        connectionPool = new GenericKeyedObjectPool(new MqttConnectorConnectionFactory(this), config);
        if (retryPolicyTemplate == null) {
            retryPolicyTemplate = muleContext.getRegistry().lookupObject(MuleProperties.OBJECT_DEFAULT_RETRY_POLICY_TEMPLATE);
        }
    }

    public MqttConnectorConnectionIdentifierAdapter acquireConnection(MqttConnectorConnectionKey key)
        throws Exception
    {
        return ((MqttConnectorConnectionIdentifierAdapter) connectionPool.borrowObject(key));
    }

    public void releaseConnection(MqttConnectorConnectionKey key, MqttConnectorConnectionIdentifierAdapter connection)
        throws Exception
    {
        connectionPool.returnObject(key, connection);
    }

    public void destroyConnection(MqttConnectorConnectionKey key, MqttConnectorConnectionIdentifierAdapter connection)
        throws Exception
    {
        connectionPool.invalidateObject(key, connection);
    }

    /**
     * Returns true if this module implements such capability
     * 
     */
    public boolean isCapableOf(Capability capability) {
        if (capability == Capability.LIFECYCLE_CAPABLE) {
            return true;
        }
        if (capability == Capability.CONNECTION_MANAGEMENT_CAPABLE) {
            return true;
        }
        return false;
    }

    @Override
    public<P >ProcessTemplate<P, MqttConnectorConnectionIdentifierAdapter> getProcessTemplate() {
        return new ManagedConnectionProcessTemplate(this, muleContext);
    }

    public MqttConnectorConnectionKey getDefaultConnectionKey() {
        return new MqttConnectorConnectionKey(getClientId());
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getModuleVersion() {
        return MODULE_VERSION;
    }

    public String getDevkitVersion() {
        return DEVKIT_VERSION;
    }

    public String getDevkitBuild() {
        return DEVKIT_BUILD;
    }

}
