
package org.mule.modules.mqtt.processors;

import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.modules.mqtt.MqttConnector;
import org.mule.modules.mqtt.MqttConnector.DeliveryQoS;
import org.mule.modules.mqtt.connectivity.MqttConnectorConnectionManager;
import org.mule.modules.mqtt.process.ProcessAdapter;
import org.mule.modules.mqtt.process.ProcessCallback;
import org.mule.modules.mqtt.process.ProcessTemplate;


/**
 * PublishMessageProcessor invokes the {@link org.mule.modules.mqtt.MqttConnector#publish(java.lang.String, java.lang.Long, org.mule.modules.mqtt.MqttConnector.DeliveryQoS, byte[], org.mule.api.MuleEvent)} method in {@link MqttConnector }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.4.0", date = "2013-05-30T07:10:26-03:00", comments = "Build 3.4.0.1555.8df15c1")
public class PublishMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Initialisable, Startable, Stoppable, MessageProcessor
{

    protected Object topicName;
    protected String _topicNameType;
    protected Object waitForCompletionTimeOut;
    protected Long _waitForCompletionTimeOutType;
    protected Object qos;
    protected DeliveryQoS _qosType;
    protected Object messagePayload;
    protected byte[] _messagePayloadType;
    protected Object muleEvent;
    protected MuleEvent _muleEventType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets qos
     * 
     * @param value Value to set
     */
    public void setQos(Object value) {
        this.qos = value;
    }

    /**
     * Sets messagePayload
     * 
     * @param value Value to set
     */
    public void setMessagePayload(Object value) {
        this.messagePayload = value;
    }

    /**
     * Sets muleEvent
     * 
     * @param value Value to set
     */
    public void setMuleEvent(Object value) {
        this.muleEvent = value;
    }

    /**
     * Sets waitForCompletionTimeOut
     * 
     * @param value Value to set
     */
    public void setWaitForCompletionTimeOut(Object value) {
        this.waitForCompletionTimeOut = value;
    }

    /**
     * Sets topicName
     * 
     * @param value Value to set
     */
    public void setTopicName(Object value) {
        this.topicName = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(MqttConnectorConnectionManager.class, true, event);
            final String _transformedTopicName = ((String) evaluateAndTransform(getMuleContext(), event, PublishMessageProcessor.class.getDeclaredField("_topicNameType").getGenericType(), null, topicName));
            final Long _transformedWaitForCompletionTimeOut = ((Long) evaluateAndTransform(getMuleContext(), event, PublishMessageProcessor.class.getDeclaredField("_waitForCompletionTimeOutType").getGenericType(), null, waitForCompletionTimeOut));
            final DeliveryQoS _transformedQos = ((DeliveryQoS) evaluateAndTransform(getMuleContext(), event, PublishMessageProcessor.class.getDeclaredField("_qosType").getGenericType(), null, qos));
            final byte[] _transformedMessagePayload = ((byte[]) evaluateAndTransform(getMuleContext(), event, PublishMessageProcessor.class.getDeclaredField("_messagePayloadType").getGenericType(), null, "#[payload]"));
            Object resultPayload;
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return null;
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((MqttConnector) object).publish(_transformedTopicName, _transformedWaitForCompletionTimeOut, _transformedQos, _transformedMessagePayload, event);
                }

            }
            , this, event);
            overwritePayload(event, resultPayload);
            return event;
        } catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("publish"), event, e);
        }
    }

}
