
package org.mule.modules.mqtt.sources;

import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.callback.SourceCallback;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.source.MessageSource;
import org.mule.modules.mqtt.MqttConnector;
import org.mule.modules.mqtt.MqttConnector.DeliveryQoS;
import org.mule.modules.mqtt.MqttTopicSubscription;
import org.mule.modules.mqtt.connectivity.MqttConnectorConnectionManager;
import org.mule.modules.mqtt.process.ProcessAdapter;
import org.mule.modules.mqtt.process.ProcessCallback;
import org.mule.modules.mqtt.process.ProcessTemplate;
import org.mule.modules.mqtt.processors.AbstractListeningMessageProcessor;


/**
 * SubscribeMessageSource wraps {@link org.mule.modules.mqtt.MqttConnector#subscribe(java.lang.String, org.mule.modules.mqtt.MqttConnector.DeliveryQoS, java.util.List, org.mule.api.callback.SourceCallback)} method in {@link MqttConnector } as a message source capable of generating Mule events.  The POJO's method is invoked in its own thread.
 * 
 */
@Generated(value = "Mule DevKit Version 3.4.0", date = "2013-05-30T07:10:26-03:00", comments = "Build 3.4.0.1555.8df15c1")
public class SubscribeMessageSource
    extends AbstractListeningMessageProcessor<Object>
    implements Runnable, FlowConstructAware, MuleContextAware, Startable, Stoppable, MessageSource
{

    protected Object topicFilter;
    protected String _topicFilterType;
    protected Object qos;
    protected DeliveryQoS _qosType;
    protected Object topicSubscriptions;
    protected List<MqttTopicSubscription> _topicSubscriptionsType;
    protected Object clientId;
    protected String _clientIdType;
    /**
     * Thread under which this message source will execute
     * 
     */
    private Thread thread;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    /**
     * Sets topicSubscriptions
     * 
     * @param value Value to set
     */
    public void setTopicSubscriptions(Object value) {
        this.topicSubscriptions = value;
    }

    /**
     * Sets qos
     * 
     * @param value Value to set
     */
    public void setQos(Object value) {
        this.qos = value;
    }

    /**
     * Sets topicFilter
     * 
     * @param value Value to set
     */
    public void setTopicFilter(Object value) {
        this.topicFilter = value;
    }

    /**
     * Sets clientId
     * 
     * @param value Value to set
     */
    public void setClientId(Object value) {
        this.clientId = value;
    }

    /**
     * Method to be called when Mule instance gets started.
     * 
     */
    public void start()
        throws MuleException
    {
        if (thread == null) {
            thread = new Thread(this, "Receiving Thread");
        }
        thread.start();
    }

    /**
     * Method to be called when Mule instance gets stopped.
     * 
     */
    public void stop()
        throws MuleException
    {
        thread.interrupt();
    }

    /**
     * Implementation {@link Runnable#run()} that will invoke the method on the pojo that this message source wraps.
     * 
     */
    public void run() {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(MqttConnectorConnectionManager.class, true, null);
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            final SourceCallback sourceCallback = this;
            final String transformedTopicFilter = ((String) transform(getMuleContext(), ((MuleEvent) null), getClass().getDeclaredField("_topicFilterType").getGenericType(), null, topicFilter));
            final DeliveryQoS transformedQos = ((DeliveryQoS) transform(getMuleContext(), ((MuleEvent) null), getClass().getDeclaredField("_qosType").getGenericType(), null, qos));
            final List<MqttTopicSubscription> transformedTopicSubscriptions = ((List<MqttTopicSubscription> ) transform(getMuleContext(), ((MuleEvent) null), getClass().getDeclaredField("_topicSubscriptionsType").getGenericType(), null, topicSubscriptions));
            processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return null;
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    ((MqttConnector) object).subscribe(transformedTopicFilter, transformedQos, transformedTopicSubscriptions, sourceCallback);
                    return null;
                }

            }
            , null, ((MuleEvent) null));
        } catch (MessagingException e) {
            getFlowConstruct().getExceptionListener().handleException(e, e.getEvent());
        } catch (Exception e) {
            getMuleContext().getExceptionListener().handleException(e);
        }
    }

}
