/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.mqtt;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttDefaultFilePersistence;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.annotations.param.Payload;
import org.mule.api.callback.SourceCallback;
import org.mule.api.context.MuleContextAware;
import org.mule.modules.mqtt.MqttTopicListener;
import org.mule.modules.mqtt.MqttTopicSubscription;
import org.mule.modules.mqtt.holders.MqttTopicSubscriptionExpressionHolder;
import org.mule.util.StringUtils;

public class MqttConnector
implements MuleContextAware {
    private static final Log LOGGER = LogFactory.getLog(MqttConnector.class);
    public static final String MQTT_PROPERTIES_PREFIX = "mqtt";
    public static final String MQTT_TOPIC_NAME_PROPERTY = "mqtt.topicName";
    public static final String MQTT_QOS_PROPERTY = "mqtt.qos";
    public static final String MQTT_DELIVERY_TOKEN_VARIABLE = "mqtt.deliveryToken";
    public static final String MQTT_DEFAULT_BROKER_URI = "tcp://localhost:1883";
    private static final String MQTT_DEFAULT_QOS_STRING = "AT_LEAST_ONCE";
    public static final DeliveryQoS MQTT_DEFAULT_QOS = DeliveryQoS.valueOf("AT_LEAST_ONCE");
    private String brokerServerUri;
    private boolean cleanSession;
    private String username;
    private String password;
    private int connectionTimeout = 30;
    private String lwtTopicName;
    private String lwtMessage;
    private int lwtQos;
    private boolean lwtRetained;
    private int keepAliveInterval = 60;
    private String persistenceLocation;
    private MuleContext muleContext;
    private String clientId;
    private MqttClient client;
    private MqttConnectOptions connectOptions;

    public void connect(String clientId) throws ConnectionException {
        this.clientId = clientId;
        MqttClientPersistence clientPersistence = this.initializeClientPersistence();
        this.setupConnectOptions();
        try {
            LOGGER.debug((Object)("Creating client with ID of " + this.getActiveClientId()));
            this.client = new MqttClient(this.getBrokerServerUri(), this.getActiveClientId(), clientPersistence);
        }
        catch (MqttException me) {
            throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, null, "Failed to create the MQTT client", (Throwable)me);
        }
        if (StringUtils.isNotBlank((String)this.getLwtTopicName()) && StringUtils.isNotEmpty((String)this.getLwtMessage())) {
            LOGGER.debug((Object)"Setting up last will information...");
            MqttTopic lwtTopic = this.client.getTopic(this.getLwtTopicName());
            this.connectOptions.setWill(lwtTopic, this.getLwtMessage().getBytes(), this.getLwtQos(), false);
            LOGGER.info((Object)"Last will information configured");
        }
        try {
            LOGGER.debug((Object)("Connecting client with ID of " + this.getActiveClientId()));
            this.client.connect(this.connectOptions);
        }
        catch (MqttException me) {
            throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, null, "Failed to connect the MQTT client", (Throwable)me);
        }
        LOGGER.info((Object)("MQTT client successfully connected with ID: " + this.getActiveClientId() + " at: " + this.getBrokerServerUri()));
    }

    private MqttClientPersistence initializeClientPersistence() throws ConnectionException {
        if (StringUtils.isBlank((String)this.getPersistenceLocation())) {
            return null;
        }
        try {
            MqttDefaultFilePersistence clientPersistence = new MqttDefaultFilePersistence(this.getPersistenceLocation());
            LOGGER.info((Object)("File persistence activated at: " + this.getPersistenceLocation()));
            return clientPersistence;
        }
        catch (MqttPersistenceException mpe) {
            throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, "", "Error creating file persistence for messages", (Throwable)mpe);
        }
    }

    private void setupConnectOptions() {
        this.connectOptions = new MqttConnectOptions();
        this.connectOptions.setCleanSession(this.isCleanSession());
        this.connectOptions.setConnectionTimeout(this.getConnectionTimeout());
        this.connectOptions.setKeepAliveInterval(this.getKeepAliveInterval());
        this.connectOptions.setUserName(this.getUsername());
        if (StringUtils.isNotBlank((String)this.getPassword())) {
            this.connectOptions.setPassword(this.getPassword().toCharArray());
        }
    }

    public void disconnect() throws MqttException {
        if (this.client != null && this.client.isConnected()) {
            LOGGER.info((Object)"Diconnecting from MQTT broker...");
            this.client.disconnect();
        }
        this.client = null;
        this.connectOptions = null;
    }

    public boolean isConnected() {
        return this.client != null && this.client.isConnected();
    }

    public String getActiveClientId() {
        boolean isExpression = StringUtils.startsWith((String)this.clientId, (String)"#[");
        return isExpression ? (String)this.muleContext.getExpressionLanguage().evaluate(this.clientId) : this.clientId;
    }

    @Inject
    public byte[] publish(String topicName, Long waitForCompletionTimeOut, DeliveryQoS qos, @Payload byte[] messagePayload, MuleEvent muleEvent) throws MqttException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Retrieving topic '" + topicName + "'"));
        }
        MqttTopic topic = this.client.getTopic(topicName);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Preparing message");
        }
        MqttMessage mqttMessage = new MqttMessage(messagePayload);
        mqttMessage.setQos(qos.getCode());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Publishing message to broker with QoS: " + (Object)((Object)qos)));
        }
        MqttDeliveryToken token = topic.publish(mqttMessage);
        if (waitForCompletionTimeOut != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Waiting for completion for a maximum of " + waitForCompletionTimeOut + "ms"));
            }
            token.waitForCompletion(waitForCompletionTimeOut.longValue());
        }
        muleEvent.setFlowVariable(MQTT_DELIVERY_TOKEN_VARIABLE, (Object)token);
        return messagePayload;
    }

    public void subscribe(String topicFilter, DeliveryQoS qos, List<MqttTopicSubscription> topicSubscriptions, SourceCallback callback) throws ConnectionException {
        ArrayList<MqttTopicSubscription> actualSubscriptions = new ArrayList<MqttTopicSubscription>();
        if (topicSubscriptions != null) {
            List<MqttTopicSubscription> typelessTopicSubscriptions = topicSubscriptions;
            for (MqttTopicSubscription o : typelessTopicSubscriptions) {
                MqttTopicSubscriptionExpressionHolder holder = (MqttTopicSubscriptionExpressionHolder)((Object)o);
                if (holder.getTopicFilter() == null) continue;
                MqttTopicSubscription topicSubscription = new MqttTopicSubscription(holder.getTopicFilter().toString(), holder.getQos() == null ? null : DeliveryQoS.valueOf(holder.getQos().toString()));
                actualSubscriptions.add(new MqttTopicSubscription(topicSubscription.getTopicFilter(), topicSubscription.getQos()));
            }
        }
        if (StringUtils.isNotBlank((String)topicFilter)) {
            actualSubscriptions.add(new MqttTopicSubscription(topicFilter, qos));
        }
        Validate.notEmpty(actualSubscriptions, (String)"No topic filter has been defined to subscribe to");
        new MqttTopicListener(this, callback, actualSubscriptions).connect();
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public MqttClient getMqttClient() {
        return this.client;
    }

    public String getBrokerServerUri() {
        return this.brokerServerUri;
    }

    public void setBrokerServerUri(String brokerServerUri) {
        this.brokerServerUri = brokerServerUri;
    }

    public boolean isCleanSession() {
        return this.cleanSession;
    }

    public void setCleanSession(boolean cleanSession) {
        this.cleanSession = cleanSession;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public String getLwtTopicName() {
        return this.lwtTopicName;
    }

    public void setLwtTopicName(String lwtTopicName) {
        this.lwtTopicName = lwtTopicName;
    }

    public String getLwtMessage() {
        return this.lwtMessage;
    }

    public void setLwtMessage(String lwtMessage) {
        this.lwtMessage = lwtMessage;
    }

    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public void setKeepAliveInterval(int keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
    }

    public String getPersistenceLocation() {
        return this.persistenceLocation;
    }

    public void setPersistenceLocation(String persistenceLocation) {
        this.persistenceLocation = persistenceLocation;
    }

    public int getLwtQos() {
        return this.lwtQos;
    }

    public void setLwtQos(int lwtQos) {
        this.lwtQos = lwtQos;
    }

    public boolean isLwtRetained() {
        return this.lwtRetained;
    }

    public void setLwtRetained(boolean lwtRetained) {
        this.lwtRetained = lwtRetained;
    }

    public static enum DeliveryQoS {
        FIRE_AND_FORGET(0),
        AT_LEAST_ONCE(1),
        ONLY_ONCE(2);

        private final int code;

        private DeliveryQoS(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static DeliveryQoS fromCode(int code) {
            for (DeliveryQoS qos : DeliveryQoS.values()) {
                if (qos.getCode() != code) continue;
                return qos;
            }
            throw new IllegalArgumentException(code + " is not a valid QoS value");
        }
    }
}

