/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.mqtt;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.api.callback.SourceCallback;
import org.mule.api.retry.RetryCallback;
import org.mule.api.retry.RetryContext;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.modules.mqtt.MqttConnector;
import org.mule.modules.mqtt.MqttTopicSubscription;

public class MqttTopicListener
implements MqttCallback {
    private static final Log LOGGER = LogFactory.getLog(MqttTopicListener.class);
    private final MqttConnector connector;
    private final SourceCallback callback;
    private final List<MqttTopicSubscription> subscriptions;

    public MqttTopicListener(MqttConnector connector, SourceCallback callback, List<MqttTopicSubscription> subscriptions) {
        this.connector = connector;
        this.callback = callback;
        this.subscriptions = subscriptions;
    }

    public void connect() throws ConnectionException {
        String[] topicFilters = new String[this.subscriptions.size()];
        int[] qoss = new int[this.subscriptions.size()];
        int i = 0;
        for (MqttTopicSubscription subscription : this.subscriptions) {
            topicFilters[i] = subscription.getTopicFilter();
            qoss[i] = subscription.getQos().getCode();
            ++i;
        }
        try {
            this.connector.getMqttClient().setCallback((MqttCallback)this);
            this.connector.getMqttClient().subscribe(topicFilters, qoss);
        }
        catch (MqttException me) {
            throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, null, "Subscription Error", (Throwable)me);
        }
        LOGGER.info((Object)("Subscribed to: " + this.subscriptions));
    }

    public void connectionLost(Throwable throwable) {
        try {
            this.reconnect(throwable);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Failed to reconnect listener for: " + this.subscriptions), (Throwable)e);
        }
    }

    private void reconnect(final Throwable throwable) throws Exception {
        RetryPolicyTemplate retryPolicyTemplate = (RetryPolicyTemplate)this.connector.getMuleContext().getRegistry().lookupObject("_defaultRetryPolicyTemplate");
        retryPolicyTemplate.execute(new RetryCallback(){

            public String getWorkDescription() {
                return "Reconnection of listener for: " + MqttTopicListener.this.subscriptions;
            }

            public void doWork(RetryContext context) throws Exception {
                LOGGER.error((Object)"Disconnecting connector after losing connection", throwable);
                try {
                    MqttTopicListener.this.connector.disconnect();
                }
                catch (MqttException me) {
                    LOGGER.warn((Object)"Failed to cleanly disconnect connector", (Throwable)me);
                }
                MqttTopicListener.this.connector.connect(MqttTopicListener.this.connector.getActiveClientId());
                MqttTopicListener.this.connect();
            }
        }, this.connector.getMuleContext().getWorkManager());
    }

    public void messageArrived(MqttTopic mqttTopic, MqttMessage mqttMessage) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Message arrived on topic: " + mqttTopic.getName() + " is: " + mqttMessage));
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("mqtt.topicName", mqttTopic.getName());
        properties.put("mqtt.qos", (Object)MqttConnector.DeliveryQoS.fromCode(mqttMessage.getQos()));
        this.callback.process((Object)mqttMessage.getPayload(), properties);
    }

    public void deliveryComplete(MqttDeliveryToken mqttDeliveryToken) {
    }
}

