/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.mqtt.config;

import org.mule.config.PoolingProfile;
import org.mule.modules.mqtt.config.AbstractDefinitionParser;
import org.mule.modules.mqtt.connectivity.MqttConnectorConnectionManager;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class MqttConnectorConfigDefinitionParser
extends AbstractDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        this.parseConfigName(element);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)MqttConnectorConnectionManager.class.getName());
        builder.setScope("singleton");
        this.setInitMethodIfNeeded(builder, MqttConnectorConnectionManager.class);
        this.setDestroyMethodIfNeeded(builder, MqttConnectorConnectionManager.class);
        this.parseProperty(builder, element, "brokerServerUri", "brokerServerUri");
        this.parseProperty(builder, element, "cleanSession", "cleanSession");
        this.parseProperty(builder, element, "username", "username");
        this.parseProperty(builder, element, "password", "password");
        this.parseProperty(builder, element, "connectionTimeout", "connectionTimeout");
        this.parseProperty(builder, element, "lwtTopicName", "lwtTopicName");
        this.parseProperty(builder, element, "lwtMessage", "lwtMessage");
        this.parseProperty(builder, element, "lwtQos", "lwtQos");
        this.parseProperty(builder, element, "lwtRetained", "lwtRetained");
        this.parseProperty(builder, element, "keepAliveInterval", "keepAliveInterval");
        this.parseProperty(builder, element, "persistenceLocation", "persistenceLocation");
        this.parseProperty(builder, element, "clientId", "clientId");
        BeanDefinitionBuilder connectionPoolingProfileBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)PoolingProfile.class.getName());
        Element connectionPoolingProfileElement = DomUtils.getChildElementByTagName((Element)element, (String)"connection-pooling-profile");
        if (connectionPoolingProfileElement != null) {
            this.parseProperty(connectionPoolingProfileBuilder, connectionPoolingProfileElement, "maxActive");
            this.parseProperty(connectionPoolingProfileBuilder, connectionPoolingProfileElement, "maxIdle");
            this.parseProperty(connectionPoolingProfileBuilder, connectionPoolingProfileElement, "maxWait");
            if (this.hasAttribute(connectionPoolingProfileElement, "exhaustedAction")) {
                connectionPoolingProfileBuilder.addPropertyValue("exhaustedAction", PoolingProfile.POOL_EXHAUSTED_ACTIONS.get(connectionPoolingProfileElement.getAttribute("exhaustedAction")));
            }
            if (this.hasAttribute(connectionPoolingProfileElement, "initialisationPolicy")) {
                connectionPoolingProfileBuilder.addPropertyValue("initialisationPolicy", PoolingProfile.POOL_INITIALISATION_POLICIES.get(connectionPoolingProfileElement.getAttribute("initialisationPolicy")));
            }
            if (this.hasAttribute(connectionPoolingProfileElement, "evictionCheckIntervalMillis")) {
                this.parseProperty(connectionPoolingProfileBuilder, connectionPoolingProfileElement, "evictionCheckIntervalMillis");
            }
            if (this.hasAttribute(connectionPoolingProfileElement, "minEvictionMillis")) {
                this.parseProperty(connectionPoolingProfileBuilder, connectionPoolingProfileElement, "minEvictionMillis");
            }
            builder.addPropertyValue("connectionPoolingProfile", (Object)connectionPoolingProfileBuilder.getBeanDefinition());
        }
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        this.setNoRecurseOnDefinition((BeanDefinition)definition);
        this.parseRetryPolicyTemplate("reconnect", element, parserContext, builder, (BeanDefinition)definition);
        this.parseRetryPolicyTemplate("reconnect-forever", element, parserContext, builder, (BeanDefinition)definition);
        this.parseRetryPolicyTemplate("reconnect-custom-strategy", element, parserContext, builder, (BeanDefinition)definition);
        return definition;
    }
}

