/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.mqtt.connectivity;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.modules.mqtt.adapters.MqttConnectorConnectionIdentifierAdapter;
import org.mule.modules.mqtt.connectivity.MqttConnectorConnectionKey;
import org.mule.modules.mqtt.connectivity.MqttConnectorConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttConnectorConnectionFactory
implements KeyedPoolableObjectFactory {
    private static Logger logger = LoggerFactory.getLogger(MqttConnectorConnectionFactory.class);
    private MqttConnectorConnectionManager connectionManager;

    public MqttConnectorConnectionFactory(MqttConnectorConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public Object makeObject(Object key) throws Exception {
        if (!(key instanceof MqttConnectorConnectionKey)) {
            if (key == null) {
                logger.warn("Connection key is null");
            } else {
                logger.warn("Cannot cast key of type ".concat(key.getClass().getName().concat(" to ").concat("org.mule.modules.mqtt.connectivity.MqttConnectorConnectionKey")));
            }
            throw new RuntimeException("Invalid key type ".concat(key.getClass().getName()));
        }
        MqttConnectorConnectionIdentifierAdapter connector = new MqttConnectorConnectionIdentifierAdapter();
        connector.setBrokerServerUri(this.connectionManager.getBrokerServerUri());
        connector.setCleanSession(this.connectionManager.getCleanSession());
        connector.setUsername(this.connectionManager.getUsername());
        connector.setPassword(this.connectionManager.getPassword());
        connector.setConnectionTimeout(this.connectionManager.getConnectionTimeout());
        connector.setLwtTopicName(this.connectionManager.getLwtTopicName());
        connector.setLwtMessage(this.connectionManager.getLwtMessage());
        connector.setLwtQos(this.connectionManager.getLwtQos());
        connector.setLwtRetained(this.connectionManager.getLwtRetained());
        connector.setKeepAliveInterval(this.connectionManager.getKeepAliveInterval());
        connector.setPersistenceLocation(this.connectionManager.getPersistenceLocation());
        if (connector instanceof Initialisable) {
            connector.initialise();
        }
        if (connector instanceof MuleContextAware) {
            connector.setMuleContext(this.connectionManager.getMuleContext());
        }
        if (connector instanceof Startable) {
            connector.start();
        }
        if (!connector.isConnected()) {
            connector.connect(((MqttConnectorConnectionKey)key).getClientId());
        }
        return connector;
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        if (!(key instanceof MqttConnectorConnectionKey)) {
            if (key == null) {
                logger.warn("Connection key is null");
            } else {
                logger.warn("Cannot cast key of type ".concat(key.getClass().getName().concat(" to ").concat("org.mule.modules.mqtt.connectivity.MqttConnectorConnectionKey")));
            }
            throw new RuntimeException("Invalid key type ".concat(key.getClass().getName()));
        }
        if (!(obj instanceof MqttConnectorConnectionIdentifierAdapter)) {
            if (obj == null) {
                logger.warn("Connector is null");
            } else {
                logger.warn("Cannot cast connector of type ".concat(obj.getClass().getName().concat(" to ").concat("org.mule.modules.mqtt.adapters.MqttConnectorConnectionIdentifierAdapter")));
            }
            throw new RuntimeException("Invalid connector type ".concat(obj.getClass().getName()));
        }
        try {
            ((MqttConnectorConnectionIdentifierAdapter)obj).disconnect();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if ((MqttConnectorConnectionIdentifierAdapter)obj instanceof Stoppable) {
                ((Stoppable)obj).stop();
            }
            if ((MqttConnectorConnectionIdentifierAdapter)obj instanceof Disposable) {
                ((Disposable)obj).dispose();
            }
        }
    }

    public boolean validateObject(Object key, Object obj) {
        if (!(obj instanceof MqttConnectorConnectionIdentifierAdapter)) {
            if (obj == null) {
                logger.warn("Connector is null");
            } else {
                logger.warn("Cannot cast connector of type ".concat(obj.getClass().getName().concat(" to ").concat("org.mule.modules.mqtt.adapters.MqttConnectorConnectionIdentifierAdapter")));
            }
            throw new RuntimeException("Invalid connector type ".concat(obj.getClass().getName()));
        }
        try {
            return ((MqttConnectorConnectionIdentifierAdapter)obj).isConnected();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void activateObject(Object key, Object obj) throws Exception {
        if (!(key instanceof MqttConnectorConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        if (!(obj instanceof MqttConnectorConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        if (!((MqttConnectorConnectionIdentifierAdapter)obj).isConnected()) {
            ((MqttConnectorConnectionIdentifierAdapter)obj).connect(((MqttConnectorConnectionKey)key).getClientId());
        }
    }

    public void passivateObject(Object key, Object obj) throws Exception {
    }
}

