/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.mqtt.connectivity;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.mule.api.MuleContext;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.config.PoolingProfile;
import org.mule.modules.mqtt.adapters.MqttConnectorConnectionIdentifierAdapter;
import org.mule.modules.mqtt.basic.Capabilities;
import org.mule.modules.mqtt.basic.Capability;
import org.mule.modules.mqtt.basic.MetadataAware;
import org.mule.modules.mqtt.connection.ConnectionManager;
import org.mule.modules.mqtt.connectivity.ManagedConnectionProcessTemplate;
import org.mule.modules.mqtt.connectivity.MqttConnectorConnectionFactory;
import org.mule.modules.mqtt.connectivity.MqttConnectorConnectionKey;
import org.mule.modules.mqtt.process.ProcessAdapter;
import org.mule.modules.mqtt.process.ProcessTemplate;

public class MqttConnectorConnectionManager
implements MuleContextAware,
Initialisable,
Capabilities,
MetadataAware,
ConnectionManager<MqttConnectorConnectionKey, MqttConnectorConnectionIdentifierAdapter>,
ProcessAdapter<MqttConnectorConnectionIdentifierAdapter> {
    private String clientId;
    private String brokerServerUri;
    private boolean cleanSession;
    private String username;
    private String password;
    private int connectionTimeout;
    private String lwtTopicName;
    private String lwtMessage;
    private int lwtQos;
    private boolean lwtRetained;
    private int keepAliveInterval;
    private String persistenceLocation;
    protected MuleContext muleContext;
    protected FlowConstruct flowConstruct;
    private GenericKeyedObjectPool connectionPool;
    protected PoolingProfile connectionPoolingProfile;
    protected RetryPolicyTemplate retryPolicyTemplate;
    private static final String MODULE_NAME = "MQTT";
    private static final String MODULE_VERSION = "1.0";
    private static final String DEVKIT_VERSION = "3.4.0";
    private static final String DEVKIT_BUILD = "3.4.0.1555.8df15c1";

    public void setBrokerServerUri(String value) {
        this.brokerServerUri = value;
    }

    public String getBrokerServerUri() {
        return this.brokerServerUri;
    }

    public void setCleanSession(boolean value) {
        this.cleanSession = value;
    }

    public boolean getCleanSession() {
        return this.cleanSession;
    }

    public void setUsername(String value) {
        this.username = value;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public String getPassword() {
        return this.password;
    }

    public void setConnectionTimeout(int value) {
        this.connectionTimeout = value;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setLwtTopicName(String value) {
        this.lwtTopicName = value;
    }

    public String getLwtTopicName() {
        return this.lwtTopicName;
    }

    public void setLwtMessage(String value) {
        this.lwtMessage = value;
    }

    public String getLwtMessage() {
        return this.lwtMessage;
    }

    public void setLwtQos(int value) {
        this.lwtQos = value;
    }

    public int getLwtQos() {
        return this.lwtQos;
    }

    public void setLwtRetained(boolean value) {
        this.lwtRetained = value;
    }

    public boolean getLwtRetained() {
        return this.lwtRetained;
    }

    public void setKeepAliveInterval(int value) {
        this.keepAliveInterval = value;
    }

    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public void setPersistenceLocation(String value) {
        this.persistenceLocation = value;
    }

    public String getPersistenceLocation() {
        return this.persistenceLocation;
    }

    public void setMuleContext(MuleContext value) {
        this.muleContext = value;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void setFlowConstruct(FlowConstruct value) {
        this.flowConstruct = value;
    }

    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    @Override
    public void setConnectionPoolingProfile(PoolingProfile value) {
        this.connectionPoolingProfile = value;
    }

    @Override
    public PoolingProfile getConnectionPoolingProfile() {
        return this.connectionPoolingProfile;
    }

    public void setRetryPolicyTemplate(RetryPolicyTemplate value) {
        this.retryPolicyTemplate = value;
    }

    @Override
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    public void setClientId(String value) {
        this.clientId = value;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void initialise() {
        GenericKeyedObjectPool.Config config = new GenericKeyedObjectPool.Config();
        if (this.connectionPoolingProfile != null) {
            config.maxIdle = this.connectionPoolingProfile.getMaxIdle();
            config.maxActive = this.connectionPoolingProfile.getMaxActive();
            config.maxWait = this.connectionPoolingProfile.getMaxWait();
            config.whenExhaustedAction = (byte)this.connectionPoolingProfile.getExhaustedAction();
        }
        this.connectionPool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)new MqttConnectorConnectionFactory(this), config);
        if (this.retryPolicyTemplate == null) {
            this.retryPolicyTemplate = (RetryPolicyTemplate)this.muleContext.getRegistry().lookupObject("_defaultRetryPolicyTemplate");
        }
    }

    @Override
    public MqttConnectorConnectionIdentifierAdapter acquireConnection(MqttConnectorConnectionKey key) throws Exception {
        return (MqttConnectorConnectionIdentifierAdapter)this.connectionPool.borrowObject((Object)key);
    }

    @Override
    public void releaseConnection(MqttConnectorConnectionKey key, MqttConnectorConnectionIdentifierAdapter connection) throws Exception {
        this.connectionPool.returnObject((Object)key, (Object)connection);
    }

    @Override
    public void destroyConnection(MqttConnectorConnectionKey key, MqttConnectorConnectionIdentifierAdapter connection) throws Exception {
        this.connectionPool.invalidateObject((Object)key, (Object)connection);
    }

    @Override
    public boolean isCapableOf(Capability capability) {
        if (capability == Capability.LIFECYCLE_CAPABLE) {
            return true;
        }
        return capability == Capability.CONNECTION_MANAGEMENT_CAPABLE;
    }

    @Override
    public <P> ProcessTemplate<P, MqttConnectorConnectionIdentifierAdapter> getProcessTemplate() {
        return new ManagedConnectionProcessTemplate(this, this.muleContext);
    }

    @Override
    public MqttConnectorConnectionKey getDefaultConnectionKey() {
        return new MqttConnectorConnectionKey(this.getClientId());
    }

    @Override
    public String getModuleName() {
        return MODULE_NAME;
    }

    @Override
    public String getModuleVersion() {
        return MODULE_VERSION;
    }

    @Override
    public String getDevkitVersion() {
        return DEVKIT_VERSION;
    }

    @Override
    public String getDevkitBuild() {
        return DEVKIT_BUILD;
    }
}

