/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.mqtt.process;

import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.modules.mqtt.adapters.MqttConnectorConnectionIdentifierAdapter;
import org.mule.modules.mqtt.connection.ConnectionManager;
import org.mule.modules.mqtt.connection.UnableToAcquireConnectionException;
import org.mule.modules.mqtt.connection.UnableToReleaseConnectionException;
import org.mule.modules.mqtt.connectivity.MqttConnectorConnectionKey;
import org.mule.modules.mqtt.process.ProcessCallback;
import org.mule.modules.mqtt.process.ProcessInterceptor;
import org.mule.modules.mqtt.processors.AbstractConnectedProcessor;
import org.mule.modules.mqtt.processors.AbstractExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedConnectionProcessInterceptor<T>
extends AbstractExpressionEvaluator
implements ProcessInterceptor<T, MqttConnectorConnectionIdentifierAdapter> {
    private static Logger logger = LoggerFactory.getLogger(ManagedConnectionProcessInterceptor.class);
    private final ConnectionManager<MqttConnectorConnectionKey, MqttConnectorConnectionIdentifierAdapter> connectionManager;
    private final MuleContext muleContext;
    private final ProcessInterceptor<T, MqttConnectorConnectionIdentifierAdapter> next;

    public ManagedConnectionProcessInterceptor(ProcessInterceptor<T, MqttConnectorConnectionIdentifierAdapter> next, ConnectionManager<MqttConnectorConnectionKey, MqttConnectorConnectionIdentifierAdapter> connectionManager, MuleContext muleContext) {
        this.next = next;
        this.connectionManager = connectionManager;
        this.muleContext = muleContext;
    }

    @Override
    public T execute(ProcessCallback<T, MqttConnectorConnectionIdentifierAdapter> processCallback, MqttConnectorConnectionIdentifierAdapter object, MessageProcessor messageProcessor, MuleEvent event) throws Exception {
        String _transformedClientId;
        MqttConnectorConnectionIdentifierAdapter connection = null;
        MqttConnectorConnectionKey key = null;
        if (messageProcessor != null && messageProcessor instanceof AbstractConnectedProcessor && ((AbstractConnectedProcessor)messageProcessor).getClientId() != null) {
            _transformedClientId = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_clientIdType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getClientId());
            if (_transformedClientId == null) {
                throw new UnableToAcquireConnectionException("Parameter clientId in method connect can't be null because is not @Optional");
            }
            key = new MqttConnectorConnectionKey(_transformedClientId);
        } else {
            key = this.connectionManager.getDefaultConnectionKey();
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Attempting to acquire connection using " + key.toString());
            }
            if ((connection = this.connectionManager.acquireConnection(key)) == null) {
                throw new UnableToAcquireConnectionException();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Connection has been acquired with [id=" + connection.getConnectionIdentifier() + "]");
            }
            _transformedClientId = this.next.execute(processCallback, connection, messageProcessor, event);
            return (T)_transformedClientId;
        }
        catch (Exception e) {
            if (processCallback.getManagedExceptions() != null) {
                for (Class exceptionClass : processCallback.getManagedExceptions()) {
                    if (!exceptionClass.isInstance(e)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("An exception ( " + exceptionClass.getName() + ") has been thrown. Destroying the connection with [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    try {
                        this.connectionManager.destroyConnection(key, connection);
                        connection = null;
                    }
                    catch (Exception innerException) {
                        logger.error(innerException.getMessage(), (Throwable)innerException);
                    }
                }
            }
            throw e;
        }
        finally {
            try {
                if (connection != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Releasing the connection back into the pool [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    this.connectionManager.releaseConnection(key, connection);
                }
            }
            catch (Exception e) {
                throw new UnableToReleaseConnectionException(e);
            }
        }
    }

    @Override
    public T execute(ProcessCallback<T, MqttConnectorConnectionIdentifierAdapter> processCallback, MqttConnectorConnectionIdentifierAdapter object, Filter filter, MuleMessage message) throws Exception {
        throw new UnsupportedOperationException();
    }
}

