/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp;

import java.io.File;
import java.io.IOException;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.probe.Prober;
import org.mule.tck.probe.file.FileDoesNotExists;
import org.mule.tck.probe.file.FileExists;
import org.mule.util.FileUtils;

public class FileDecryptionTestCase
extends FunctionalTestCase {
    public String testFolder;
    private Prober prober = new PollingProber(30000L, 100L);

    public FileDecryptionTestCase() {
        this.setStartContext(false);
    }

    protected String getConfigFile() {
        return "file-decryption-config.xml";
    }

    protected void doSetUp() throws Exception {
        this.testFolder = this.getFileInsideWorkingDirectory("testData").getAbsolutePath();
    }

    private File createTestFile(String folder) throws IOException {
        File testFolder = new File(folder);
        testFolder.mkdirs();
        this.prober.check((Probe)new FileExists(testFolder));
        File target = File.createTempFile("mule-file-test-", ".txt", testFolder);
        target.deleteOnExit();
        FileUtils.writeStringToFile((File)target, (String)"TEST");
        this.prober.check((Probe)new FileExists(target));
        return target;
    }

    @Test
    public void decryptsFile() throws Exception {
        File target = this.createTestFile(this.testFolder);
        muleContext.start();
        File decryptedFile = this.getFile("decrypted", target.getName());
        this.prober.check((Probe)new FileExists(decryptedFile));
        File encryptedFile = this.getFile("encrypted", target.getName());
        this.prober.check((Probe)new FileDoesNotExists(encryptedFile));
    }

    private File getFile(String folderName, String fileName) {
        File subFolder = new File(this.testFolder, folderName);
        return new File(subFolder, fileName);
    }
}

