/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp;

import java.io.File;
import java.io.IOException;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.probe.Prober;
import org.mule.tck.probe.file.FileDoesNotExists;
import org.mule.tck.probe.file.FileExists;
import org.mule.util.FileUtils;

public class FileEncryptionTestCase
extends FunctionalTestCase {
    public String testFolder;
    private Prober prober = new PollingProber(30000L, 100L);

    public FileEncryptionTestCase() {
        this.setStartContext(false);
    }

    protected String getConfigFile() {
        return "file-encryption-config.xml";
    }

    protected void doSetUp() throws Exception {
        this.testFolder = this.getFileInsideWorkingDirectory("testData").getAbsolutePath();
    }

    private File createTestFile(String folder) throws IOException {
        File testFolder = new File(folder);
        testFolder.mkdirs();
        this.prober.check((Probe)new FileExists(testFolder));
        File target = File.createTempFile("mule-file-test-", ".txt", testFolder);
        target.deleteOnExit();
        FileUtils.writeStringToFile((File)target, (String)"TEST");
        this.prober.check((Probe)new FileExists(target));
        return target;
    }

    @Test
    public void testName() throws Exception {
        File target = this.createTestFile(this.testFolder);
        muleContext.start();
        this.prober.check((Probe)new FileDoesNotExists(target));
    }
}

