/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp;

import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import org.junit.Assert;
import org.junit.Test;
import org.mule.module.pgp.AbstractEncryptionStrategyTestCase;
import org.mule.module.pgp.PGPCryptInfo;
import org.mule.util.IOUtils;

public class KeyBasedEncryptionStrategyTestCase
extends AbstractEncryptionStrategyTestCase {
    @Test
    public void testDecryptCompressedSigned() throws Exception {
        this.testDecrypt("encrypted-compressed-signed.asc");
    }

    @Test
    public void testDecryptSignedCompressed() throws Exception {
        this.testDecrypt("encrypted-signed-compressed.asc");
    }

    @Test
    public void testDecryptCompressedSignedDifferentKeys() throws Exception {
        this.testDecrypt("encrypted-compressed-signed-different-keys.asc");
    }

    private void testDecrypt(String file) throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource(file);
        FileInputStream in = new FileInputStream(url.getFile());
        byte[] msg = IOUtils.toByteArray((InputStream)in);
        in.close();
        PGPCryptInfo cryptInfo = new PGPCryptInfo(this.kbStrategy.getKeyManager().getPublicKey("Mule client <mule_client@mule.com>"), true);
        String result = new String(this.kbStrategy.decrypt(msg, (Object)cryptInfo));
        Assert.assertEquals((Object)"This is a test message.\r\nThis is another line.\r\n", (Object)result);
    }

    @Test
    public void testEncrypt() throws Exception {
        String msg = "Test Message";
        PGPCryptInfo cryptInfo = new PGPCryptInfo(this.kbStrategy.getKeyManager().getPublicKey("Mule client <mule_client@mule.com>"), true);
        String result = new String(this.kbStrategy.encrypt(msg.getBytes(), (Object)cryptInfo));
        Assert.assertNotNull((Object)result);
    }
}

