/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.module.pgp.LazyTransformedInputStream;
import org.mule.module.pgp.StreamTransformer;
import org.mule.module.pgp.TransformContinuouslyPolicy;
import org.mule.module.pgp.TransformPerRequestInChunksPolicy;
import org.mule.module.pgp.TransformPerRequestPolicy;
import org.mule.module.pgp.TransformPolicy;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class LazyTransformedInputStreamTestCase
extends AbstractMuleTestCase {
    private static String message = "abcdefghij";
    private ByteArrayInputStream inputStream;
    private LazyTransformedInputStream transformedInputStream;
    private AddOneStreamTransformer simpleTransformer;

    @Before
    public void setUp() throws Exception {
        this.inputStream = new ByteArrayInputStream(message.getBytes());
        this.simpleTransformer = new AddOneStreamTransformer(this.inputStream);
    }

    @After
    public void tearDown() throws Exception {
        IOUtils.closeQuietly((InputStream)this.inputStream);
    }

    @Test
    public void testTransformPerRequestPolicy() throws Exception {
        this.transformedInputStream = new LazyTransformedInputStream((TransformPolicy)new TransformPerRequestPolicy(), (StreamTransformer)this.simpleTransformer);
        for (int i = 0; i < message.length(); ++i) {
            int read = this.transformedInputStream.read();
            Assert.assertEquals((long)(message.charAt(i) + '\u0001'), (long)read);
            Assert.assertEquals((long)(i + 1), (long)this.simpleTransformer.bytesRead);
            Thread.sleep(50L);
            Assert.assertEquals((long)(i + 1), (long)this.simpleTransformer.bytesRead);
        }
    }

    @Test
    public void testTransformPerRequestInChunksPolicy() throws Exception {
        int chunkSize = 4;
        LazyTransformedInputStream transformedInputStream = new LazyTransformedInputStream((TransformPolicy)new TransformPerRequestInChunksPolicy((long)chunkSize), (StreamTransformer)this.simpleTransformer);
        for (int i = 0; i < message.length(); ++i) {
            int read = transformedInputStream.read();
            Assert.assertEquals((long)(message.charAt(i) + '\u0001'), (long)read);
            int shouldBeTransformed = (int)Math.min((double)message.length(), Math.ceil((double)this.simpleTransformer.bytesRead / (double)chunkSize) * (double)chunkSize);
            Assert.assertEquals((long)shouldBeTransformed, (long)this.simpleTransformer.bytesRead);
            Thread.sleep(50L);
            Assert.assertEquals((long)shouldBeTransformed, (long)this.simpleTransformer.bytesRead);
        }
    }

    @Test
    public void testTransformContinuouslyPolicy() throws Exception {
        LazyTransformedInputStream transformedInputStream = new LazyTransformedInputStream((TransformPolicy)new TransformContinuouslyPolicy(), (StreamTransformer)this.simpleTransformer);
        int i = 0;
        int read = transformedInputStream.read();
        Thread.sleep(100L);
        Assert.assertEquals((long)message.length(), (long)this.simpleTransformer.bytesRead);
        do {
            Assert.assertEquals((long)(message.charAt(i) + '\u0001'), (long)read);
            read = transformedInputStream.read();
        } while (++i < message.length());
    }

    private class AddOneStreamTransformer
    implements StreamTransformer {
        private InputStream inputStream;
        private int bytesRead;
        private boolean finished;

        public AddOneStreamTransformer(InputStream inputStream) {
            this.inputStream = inputStream;
            this.bytesRead = 0;
            this.finished = false;
        }

        public boolean write(OutputStream out, AtomicLong bytesRequested) throws Exception {
            while (!this.finished && (long)(this.bytesRead + 1) <= bytesRequested.get()) {
                int byteRead = this.inputStream.read();
                if (byteRead == -1) {
                    this.finished = true;
                    out.write(-1);
                    continue;
                }
                out.write(byteRead + 1);
                ++this.bytesRead;
            }
            return this.finished;
        }

        public void initialize(OutputStream out) throws Exception {
        }
    }
}

