/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.DefaultMuleMessage;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.processor.MessageProcessor;
import org.mule.module.pgp.InvalidPublicKeyException;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.util.ExceptionUtils;

public class PGPExpiredIntegrationTestCase
extends AbstractServiceAndFlowTestCase {
    private static Throwable exceptionFromFlow = null;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "pgp-expired-integration-mule-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "pgp-expired-integration-mule-config-flow.xml"});
    }

    public PGPExpiredIntegrationTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testEncryptDecrypt() throws Exception {
        String payload = "this is a super simple test. Hope it works!!!";
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://in", (MuleMessage)new DefaultMuleMessage((Object)payload, muleContext));
        MuleMessage message = client.request("vm://out", 5000L);
        Assert.assertNull((Object)message);
        Assert.assertNotNull((String)"flow's exception strategy should have caught an exception", (Object)exceptionFromFlow);
        InvalidPublicKeyException ipke = (InvalidPublicKeyException)ExceptionUtils.getDeepestOccurenceOfType((Throwable)exceptionFromFlow, InvalidPublicKeyException.class);
        Assert.assertNotNull((String)"root cause must be a InvalidPublicKeyException", (Object)ipke);
        Assert.assertTrue((boolean)ipke.getMessage().contains("has expired"));
    }

    public static class ExceptionSaver
    implements MessageProcessor {
        public MuleEvent process(MuleEvent event) throws MuleException {
            ExceptionPayload exceptionPayload = event.getMessage().getExceptionPayload();
            exceptionFromFlow = exceptionPayload.getException();
            return null;
        }
    }
}

