/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp;

import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.security.Authentication;
import org.mule.module.pgp.AbstractEncryptionStrategyTestCase;
import org.mule.module.pgp.Message;
import org.mule.module.pgp.MessageFactory;
import org.mule.module.pgp.PGPAuthentication;
import org.mule.module.pgp.PGPSecurityProvider;

public class PGPSecurityProviderTestCase
extends AbstractEncryptionStrategyTestCase {
    private PGPSecurityProvider securityProvider;
    private Message message;

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.securityProvider = new PGPSecurityProvider();
        this.securityProvider.setKeyManager(this.keyManager);
        this.securityProvider.initialise();
        URL url = Thread.currentThread().getContextClassLoader().getResource("./signed.asc");
        FileInputStream in = new FileInputStream(url.getFile());
        this.message = MessageFactory.getMessage((byte[])IOUtils.toByteArray((InputStream)in));
    }

    @Override
    protected void doTearDown() throws Exception {
        this.securityProvider = null;
        this.message = null;
        super.doTearDown();
    }

    @Test
    public void testAuthenticate() throws Exception {
        PGPAuthentication auth = new PGPAuthentication("Mule client <mule_client@mule.com>", this.message);
        auth = this.securityProvider.authenticate((Authentication)auth);
        Assert.assertTrue((boolean)auth.isAuthenticated());
    }
}

