/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.EncryptionStrategy;
import org.mule.api.security.SecurityManager;
import org.mule.api.security.SecurityProvider;
import org.mule.module.pgp.KeyBasedEncryptionStrategy;
import org.mule.module.pgp.PGPKeyRingImpl;
import org.mule.module.pgp.PGPSecurityProvider;
import org.mule.tck.junit4.FunctionalTestCase;

public class PgpNamespaceHandlerTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "pgp-namespace-config.xml";
    }

    @Test
    public void testPgpProvider() {
        this.knownProperties(this.getProvider("pgpSecurityProvider"));
    }

    @Test
    public void testKeyBasedEncryptionStrategy() {
        this.knownProperties(this.getEncryptionStrategy("keyBasedEncryptionStrategy"));
    }

    protected SecurityProvider getProvider(String securityProviderName) {
        SecurityManager securityManager = muleContext.getSecurityManager();
        return securityManager.getProvider(securityProviderName);
    }

    protected void knownProperties(SecurityProvider provider) {
        Assert.assertNotNull((Object)provider);
        Assert.assertTrue((boolean)(provider instanceof PGPSecurityProvider));
        PGPSecurityProvider pgpProvider = (PGPSecurityProvider)provider;
        Assert.assertNotNull((Object)pgpProvider.getKeyManager());
        Assert.assertTrue((boolean)(pgpProvider.getKeyManager() instanceof PGPKeyRingImpl));
    }

    protected EncryptionStrategy getEncryptionStrategy(String encryptionStrategyName) {
        SecurityManager securityManager = muleContext.getSecurityManager();
        return securityManager.getEncryptionStrategy(encryptionStrategyName);
    }

    protected void knownProperties(EncryptionStrategy encryptionStrategy) {
        Assert.assertNotNull((Object)encryptionStrategy);
        Assert.assertTrue((boolean)(encryptionStrategy instanceof KeyBasedEncryptionStrategy));
        KeyBasedEncryptionStrategy keyBased = (KeyBasedEncryptionStrategy)encryptionStrategy;
        Assert.assertNotNull((Object)keyBased.getKeyManager());
        Assert.assertTrue((boolean)(keyBased.getKeyManager() instanceof PGPKeyRingImpl));
    }
}

