/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp;

import java.net.URL;
import org.mule.api.security.CredentialsAccessor;
import org.mule.module.pgp.FakeCredentialAccessor;
import org.mule.module.pgp.KeyBasedEncryptionStrategy;
import org.mule.module.pgp.PGPKeyRing;
import org.mule.module.pgp.PGPKeyRingImpl;
import org.mule.module.pgp.config.PGPOutputMode;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public abstract class AbstractEncryptionStrategyTestCase
extends AbstractMuleContextTestCase {
    protected KeyBasedEncryptionStrategy kbStrategy;
    protected PGPKeyRing keyManager;

    protected void doSetUp() throws Exception {
        PGPKeyRingImpl keyM = new PGPKeyRingImpl();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource("./serverPublic.gpg");
        keyM.setPublicKeyRingFileName(url.getFile());
        url = loader.getResource("./serverPrivate.gpg");
        keyM.setSecretKeyRingFileName(url.getFile());
        keyM.setSecretAliasId("56B4312E6168F39C");
        keyM.setSecretPassphrase("TestingPassphrase");
        keyM.initialise();
        this.kbStrategy = new KeyBasedEncryptionStrategy();
        this.kbStrategy.setKeyManager((PGPKeyRing)keyM);
        this.kbStrategy.setPgpOutputMode(PGPOutputMode.ARMOR);
        this.kbStrategy.setCredentialsAccessor((CredentialsAccessor)new FakeCredentialAccessor("Mule server <mule_server@mule.com>"));
        this.keyManager = keyM;
    }

    protected void doTearDown() throws Exception {
        this.kbStrategy = null;
        this.keyManager = null;
    }
}

