/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.RequestContext;
import org.mule.api.EncryptionStrategy;
import org.mule.api.MuleEvent;
import org.mule.api.construct.FlowConstruct;
import org.mule.module.pgp.AbstractEncryptionStrategyTestCase;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.transformer.encryption.EncryptionTransformer;
import org.mule.transformer.simple.ByteArrayToObject;

public class KBEStrategyUsingEncryptionTransformerTestCase
extends AbstractEncryptionStrategyTestCase {
    private static final String ARMOR_HEADER = "-----BEGIN PGP MESSAGE-----";
    private static final String ARMOR_FOOTER = "-----END PGP MESSAGE-----\n";

    @Test
    public void testEncrypt() throws Exception {
        String msg = "Test Message";
        MuleEvent event = KBEStrategyUsingEncryptionTransformerTestCase.getTestEvent((Object)msg, (FlowConstruct)KBEStrategyUsingEncryptionTransformerTestCase.getTestService((String)"orange", Orange.class));
        event = RequestContext.setEvent((MuleEvent)event);
        EncryptionTransformer etrans = new EncryptionTransformer();
        this.kbStrategy.initialise();
        etrans.setStrategy((EncryptionStrategy)this.kbStrategy);
        Object result = etrans.doTransform((Object)msg.getBytes(), "UTF-8");
        Assert.assertNotNull((Object)result);
        InputStream inputStream = (InputStream)result;
        String message = IOUtils.toString((InputStream)inputStream);
        String encrypted = (String)new ByteArrayToObject().doTransform((Object)message.getBytes(), "UTF-8");
        Assert.assertThat((Object)encrypted, (Matcher)CoreMatchers.startsWith((String)ARMOR_HEADER));
        Assert.assertThat((Object)encrypted, (Matcher)CoreMatchers.endsWith((String)ARMOR_FOOTER));
    }
}

