/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp;

import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.security.CredentialsAccessor;
import org.mule.api.security.CryptoFailureException;
import org.mule.module.pgp.AbstractEncryptionStrategyTestCase;
import org.mule.module.pgp.EncryptionAlgorithm;
import org.mule.module.pgp.FakeCredentialAccessor;
import org.mule.module.pgp.PGPCryptInfo;
import org.mule.module.pgp.PGPKeyRing;
import org.mule.module.pgp.i18n.PGPMessages;
import org.mule.util.IOUtils;

public class KeyBasedEncryptionStrategyTestCase
extends AbstractEncryptionStrategyTestCase {
    @Test
    public void testDecryptCompressedSigned() throws Exception {
        this.testDecrypt("encrypted-compressed-signed.asc");
    }

    @Test
    public void testDecryptSignedCompressed() throws Exception {
        this.testDecrypt("encrypted-signed-compressed.asc");
    }

    @Test
    public void testDecryptCompressedSignedDifferentKeys() throws Exception {
        this.testDecrypt("encrypted-compressed-signed-different-keys.asc");
    }

    private void testDecrypt(String file) throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource(file);
        FileInputStream in = new FileInputStream(url.getFile());
        byte[] msg = IOUtils.toByteArray((InputStream)in);
        in.close();
        PGPCryptInfo cryptInfo = new PGPCryptInfo(this.kbStrategy.getKeyManager().getPublicKey("Mule client <mule_client@mule.com>"), true);
        this.kbStrategy.initialise();
        String result = new String(this.kbStrategy.decrypt(msg, (Object)cryptInfo));
        Assert.assertEquals((Object)"This is a test message.\r\nThis is another line.\r\n", (Object)result);
    }

    @Test
    public void testEncryptWithCustomAlgorithm() throws Exception {
        String msg = "Test Message";
        PGPCryptInfo cryptInfo = new PGPCryptInfo(this.kbStrategy.getKeyManager().getPublicKey("Mule client <mule_client@mule.com>"), true);
        this.kbStrategy.setEncryptionAlgorithm(EncryptionAlgorithm.AES_256.toString());
        this.kbStrategy.initialise();
        String result = new String(this.kbStrategy.encrypt(msg.getBytes(), (Object)cryptInfo));
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testEncryptWithDefaultAlgorithm() throws Exception {
        String msg = "Test Message";
        PGPCryptInfo cryptInfo = new PGPCryptInfo(this.kbStrategy.getKeyManager().getPublicKey("Mule client <mule_client@mule.com>"), true);
        this.kbStrategy.initialise();
        String result = new String(this.kbStrategy.encrypt(msg.getBytes(), (Object)cryptInfo));
        Assert.assertNotNull((Object)result);
    }

    @Test(expected=RuntimeException.class)
    public void testEncryptWithInvalidAlgorithm() throws Exception {
        String msg = "Test Message";
        PGPCryptInfo cryptInfo = new PGPCryptInfo(this.kbStrategy.getKeyManager().getPublicKey("Mule client <mule_client@mule.com>"), true);
        this.kbStrategy.setEncryptionAlgorithm("invalid algorithm");
        this.kbStrategy.initialise();
        String result = new String(this.kbStrategy.encrypt(msg.getBytes(), (Object)cryptInfo));
    }

    @Test
    public void testInvalidPrincipal() {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        FakeCredentialAccessor credentialAccessor = new FakeCredentialAccessor("Invalid Principle <invalidPrinciple@mule.com>");
        this.kbStrategy.setCredentialsAccessor((CredentialsAccessor)credentialAccessor);
        try {
            this.kbStrategy.encrypt(inputStream, null);
            Assert.fail((String)"CryptoFailureException should be triggered because principal is wrong");
        }
        catch (CryptoFailureException cryptoFailureException) {
            Assert.assertThat((Object)cryptoFailureException.getMessage(), (Matcher)CoreMatchers.containsString((String)PGPMessages.noPublicKeyForPrincipal((String)credentialAccessor.getCredentials()).getMessage()));
        }
    }

    @Test
    public void testNoDefinedSecretPassPhrase() throws Exception {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        PGPCryptInfo pgpCryptInfo = (PGPCryptInfo)Mockito.mock(PGPCryptInfo.class);
        PGPKeyRing keyManager = (PGPKeyRing)Mockito.mock(PGPKeyRing.class);
        CredentialsAccessor credentialsAccessor = (CredentialsAccessor)Mockito.mock(CredentialsAccessor.class);
        this.kbStrategy.setCredentialsAccessor(credentialsAccessor);
        this.kbStrategy.setKeyManager(keyManager);
        try {
            this.kbStrategy.decrypt(inputStream, (Object)pgpCryptInfo);
            Assert.fail((String)"CryptoFailureException should be triggered because secretPassPhrase is not defined");
        }
        catch (CryptoFailureException cryptoFailureException) {
            Assert.assertThat((Object)cryptoFailureException.getMessage(), (Matcher)CoreMatchers.containsString((String)PGPMessages.noSecretPassPhrase().getMessage()));
        }
    }
}

