/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp;

import java.net.URL;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.module.pgp.AbstractEncryptionStrategyTestCase;
import org.mule.module.pgp.PGPKeyRingImpl;

public class PGPKeyRingTestCase
extends AbstractEncryptionStrategyTestCase {
    @Test
    public void testClientKey() {
        PGPPublicKey clientKey = this.keyManager.getPublicKey("Mule client <mule_client@mule.com>");
        Assert.assertNotNull((Object)clientKey);
    }

    @Test
    public void testServerKey() {
        PGPSecretKey serverKey = this.keyManager.getConfiguredSecretKey();
        Assert.assertNotNull((Object)serverKey);
    }

    @Test
    public void testSubKeyIsToken() throws Exception {
        String publicSubKey = "3879972755627455806";
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL urlPublicKey = loader.getResource("./mule.gpg");
        ((PGPKeyRingImpl)this.keyManager).setPublicKeyRingFileName(urlPublicKey.getFile());
        ((PGPKeyRingImpl)this.keyManager).initialise();
        Long resultKeyId = this.keyManager.getPublicKey("fernando.federico (Testing pgp) <fernando.federico@mulesoft.com>").getKeyID();
        Assert.assertThat((Object)publicSubKey, (Matcher)CoreMatchers.is((Object)resultKeyId.toString()));
    }
}

