/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.module.pgp.PGPKeyRingImpl;
import org.mule.module.pgp.exception.MissingPGPKeyException;
import org.mule.module.pgp.i18n.PGPMessages;

public class PGPKeyRingValidationsTestCase {
    private PGPKeyRingImpl pgpKeyRing = new PGPKeyRingImpl();

    @Test
    public void testInvalidPublicKeyRingFileName() {
        this.pgpKeyRing.setPublicKeyRingFileName("incorrectPath");
        try {
            this.pgpKeyRing.getPublicKey("xx");
            Assert.fail((String)"InitialisationException should be triggered because public key file doesn't exist");
        }
        catch (MissingPGPKeyException missingPGPKeyException) {
            Assert.assertThat((Object)missingPGPKeyException.getMessage(), (Matcher)Matchers.is((Object)PGPMessages.noFileKeyFound((String)"incorrectPath").getMessage()));
        }
    }

    @Test
    public void testInvalidSecretKeyRingFileName() {
        this.pgpKeyRing.setSecretKeyRingFileName("incorrectPath");
        try {
            this.pgpKeyRing.getConfiguredSecretKey();
            Assert.fail((String)"MissingPGPKeyException should be triggered because Secret Key File doesn't exist");
        }
        catch (MissingPGPKeyException missingPGPKeyException) {
            Assert.assertThat((Object)missingPGPKeyException.getMessage(), (Matcher)Matchers.is((Object)PGPMessages.noFileKeyFound((String)"incorrectPath").getMessage()));
        }
    }
}

