/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.util.IOUtils;

public class PGPSecurityFilterTestCase
extends AbstractServiceAndFlowTestCase {
    protected static final String TARGET = "/encrypted.txt";

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "test-pgp-encrypt-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "test-pgp-encrypt-config-flow.xml"});
    }

    public PGPSecurityFilterTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testAuthenticationAuthorised() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        byte[] msg = this.loadEncryptedMessage();
        Map<String, Object> props = this.createMessageProperties();
        client.send("vm://echo", (Object)new String(msg), props);
        MuleMessage message = client.request("vm://output", 5000L);
        Assert.assertEquals((Object)"This is a test message.\r\nThis is another line.\r\n", (Object)message.getPayloadAsString());
    }

    @Test
    public void testAuthenticationNotAuthorised() throws Exception {
        Map<String, Object> props = this.createMessageProperties();
        MuleMessage reply = muleContext.getClient().send("vm://echo", (Object)"An unsigned message", props);
        Assert.assertNotNull((Object)reply.getExceptionPayload());
        ExceptionPayload excPayload = reply.getExceptionPayload();
        Assert.assertThat((Object)excPayload.getMessage(), (Matcher)CoreMatchers.containsString((String)"Invalid PGP message"));
    }

    private byte[] loadEncryptedMessage() throws IOException {
        URL url = Thread.currentThread().getContextClassLoader().getResource("./encrypted-compressed-signed.asc");
        FileInputStream in = new FileInputStream(url.getFile());
        byte[] msg = IOUtils.toByteArray((InputStream)in);
        in.close();
        return msg;
    }

    private Map<String, Object> createMessageProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("TARGET_FILE", TARGET);
        props.put("MULE_USER", "Mule server <mule_server@mule.com>");
        return props;
    }
}

