/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.security.CryptoFailureException;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.util.ExceptionUtils;

public class PGPWithoutSecretKeyTestCase
extends FunctionalTestCase {
    private static final String NO_SECRET_KEY_RING_FILENAME_DEFINED = "No secret key ring filename defined";
    public String testFolder;
    private static Throwable exceptionFromFlow = null;

    public PGPWithoutSecretKeyTestCase() {
        this.setStartContext(true);
    }

    protected String getConfigFile() {
        return "file-decryption-config-no-secret-key.xml";
    }

    protected void doSetUp() throws Exception {
        this.testFolder = this.getFileInsideWorkingDirectory("testData").getAbsolutePath();
    }

    @Test
    public void whenNoSecretKeyFilenameProvidedAndEncryptThenNoError() throws Exception {
        MuleEvent event = this.runFlow("pgpEncryptProcessor", "Test Message");
        MatcherAssert.assertThat((Object)event.getMessage().getExceptionPayload(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void whenNoSecretKeyFilenameProvidedAndDecryptThenFlowError() throws Exception {
        this.runFlow("pgpDecryptProcessor", "Test Message");
        CryptoFailureException cryptoFailureException = (CryptoFailureException)((Object)ExceptionUtils.getDeepestOccurenceOfType((Throwable)exceptionFromFlow, CryptoFailureException.class));
        MatcherAssert.assertThat((Object)cryptoFailureException.getCause().getMessage(), (Matcher)CoreMatchers.equalTo((Object)NO_SECRET_KEY_RING_FILENAME_DEFINED));
    }

    public static class ExceptionSaver
    implements MessageProcessor {
        public MuleEvent process(MuleEvent event) throws MuleException {
            ExceptionPayload exceptionPayload = event.getMessage().getExceptionPayload();
            exceptionFromFlow = exceptionPayload.getException();
            return null;
        }
    }
}

