/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp;

import java.io.InputStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.api.MuleEvent;
import org.mule.module.pgp.PGPKeyRingImpl;
import org.mule.module.pgp.i18n.PGPMessages;
import org.mule.tck.junit4.FunctionalTestCase;

public class SecretAliasIdTestCase
extends FunctionalTestCase {
    private static String secretAliasId;
    private static final String VALID_KEY = "56B4312E6168F39C";
    private static final String INVALID_KEY = "35D86EAA0D5E353E";
    private static final String NONEXISTENT_KEY = "FFFFFFFFFFFFFFFF";
    private static final String PAYLOAD = "Testing secretAliasId";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private InputStream encryptedData;

    protected String getConfigFile() {
        return "secret-alias-id-config.xml";
    }

    @Before
    public void setUp() throws Exception {
        this.encryptedData = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("test-secret-id.asc");
    }

    @Test
    public void getSecretKeyFromEncryptedMessage() throws Exception {
        secretAliasId = null;
        MuleEvent result = this.runFlow("decryptFlow", SecretAliasIdTestCase.getTestEvent((Object)this.encryptedData));
        Assert.assertThat((Object)result.getMessage().getPayloadAsString(), (Matcher)CoreMatchers.is((Object)PAYLOAD));
    }

    @Test
    public void getSecretKeyFromValidConfiguredSecretAliasId() throws Exception {
        secretAliasId = VALID_KEY;
        MuleEvent result = this.runFlow("decryptFlow", SecretAliasIdTestCase.getTestEvent((Object)this.encryptedData));
        Assert.assertThat((Object)result.getMessage().getPayloadAsString(), (Matcher)CoreMatchers.is((Object)PAYLOAD));
    }

    @Test
    public void getSecretKeyFromInvalidConfiguredSecretAliasId() throws Exception {
        secretAliasId = INVALID_KEY;
        this.expectedException.expectMessage(String.format("User selected private key ID %s (through secretAliasId) but message was encrypted for key ID %s", INVALID_KEY, VALID_KEY));
        this.runFlow("decryptFlow", SecretAliasIdTestCase.getTestEvent((Object)this.encryptedData));
    }

    @Test
    public void getSecretKeyFromNonexistentSecretAliasId() throws Exception {
        secretAliasId = NONEXISTENT_KEY;
        this.expectedException.expectMessage(PGPMessages.noKeyIdFound((String)NONEXISTENT_KEY).getMessage());
        this.runFlow("decryptFlow", SecretAliasIdTestCase.getTestEvent((Object)this.encryptedData));
    }

    public static class TestPGPKeyRing
    extends PGPKeyRingImpl {
        public String getSecretAliasId() {
            return secretAliasId;
        }
    }
}

