/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp;

import java.io.InputStream;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.module.pgp.PGPKeyRingImpl;
import org.mule.tck.junit4.FunctionalTestCase;

public class SecretPassPhraseTestCase
extends FunctionalTestCase {
    private static String secretPassPhrase;
    private static final String VALID_KEY = "56B4312E6168F39C";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private InputStream encryptedData;

    protected String getConfigFile() {
        return "secret-pass-phrase-config.xml";
    }

    @Before
    public void setUp() throws Exception {
        this.encryptedData = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("test-secret-id.asc");
    }

    @Test
    public void testInvalidSecretPassPhrase() throws Exception {
        secretPassPhrase = "WrongPassPhrase";
        this.expectedException.expectMessage(String.format("PassPhrase '%s' is invalid for the private key with id '%s'", secretPassPhrase, VALID_KEY));
        this.runFlow("decryptFlow", SecretPassPhraseTestCase.getTestEvent((Object)this.encryptedData));
    }

    public static class TestPGPKeyRing
    extends PGPKeyRingImpl {
        public String getSecretPassphrase() {
            return secretPassPhrase;
        }
    }
}

