/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.util.Iterator;
import org.apache.commons.lang.Validate;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.mule.module.pgp.StreamTransformer;
import org.mule.module.pgp.util.BouncyCastleUtil;

public class DecryptStreamTransformer
implements StreamTransformer {
    public static final String INVALID_KEY_ERROR_MESSAGE = "User selected private key ID %s (through secretAliasId) but message was encrypted for key ID %s";
    public static final String INVALID_PGP_MESSAGE_ERROR = "Invalid PGP message";
    public static final String INVALID_PASS_PHRASE_ERROR_MESSAGE = "PassPhrase '%s' is invalid for the private key with id '%s'";
    private static final String CHECKSUM_MESSAGE = "checksum mismatch";
    private final PGPPublicKeyRingCollection publicKeys;
    private PGPSecretKeyRingCollection secretKeys;
    private PGPSecretKey secretKey;
    private String password;
    private final boolean configuredSecretKey;
    private InputStream compressedStream;
    private InputStream clearStream;
    private boolean validateSignatureIfFound = false;

    public DecryptStreamTransformer(PGPSecretKey secretKey, PGPSecretKeyRingCollection secretKeys, PGPPublicKeyRingCollection publicKeys, String password) throws IOException {
        Validate.notNull((Object)password, (String)"The password should not be null");
        this.configuredSecretKey = secretKey != null;
        this.secretKey = secretKey;
        this.secretKeys = secretKeys;
        this.publicKeys = publicKeys;
        this.password = password;
    }

    public DecryptStreamTransformer setValidateSignatureIfFound(boolean validate) {
        this.validateSignatureIfFound = validate;
        return this;
    }

    @Override
    public InputStream process(InputStream toBeDecrypted) throws Exception {
        int readBytesCount;
        InputStream decodedInputStream = PGPUtil.getDecoderStream((InputStream)toBeDecrypted);
        JcaPGPObjectFactory pgpF = new JcaPGPObjectFactory(decodedInputStream);
        Object pgpObject = pgpF.nextObject();
        if (pgpObject == null) {
            throw new PGPException(INVALID_PGP_MESSAGE_ERROR);
        }
        PGPEncryptedDataList enc = pgpObject instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)pgpObject : (PGPEncryptedDataList)pgpF.nextObject();
        Iterator it = enc.getEncryptedDataObjects();
        PGPPublicKeyEncryptedData pbe = null;
        PGPPrivateKey privateKey = null;
        while (privateKey == null && it.hasNext()) {
            pbe = (PGPPublicKeyEncryptedData)it.next();
            privateKey = this.getPrivateKey(pbe.getKeyID(), this.password);
            if (privateKey != null) continue;
            throw new PGPException("Failed to find private key with ID " + pbe.getKeyID());
        }
        this.clearStream = pbe.getDataStream((PublicKeyDataDecryptorFactory)new BcPublicKeyDataDecryptorFactory(privateKey));
        JcaPGPObjectFactory pgpObjectFactory = new JcaPGPObjectFactory(this.clearStream);
        pgpObject = pgpObjectFactory.nextObject();
        PGPOnePassSignature onePassSignature = null;
        while (!(pgpObject instanceof PGPLiteralData)) {
            if (pgpObject instanceof PGPOnePassSignatureList) {
                if (this.validateSignatureIfFound) {
                    onePassSignature = ((PGPOnePassSignatureList)pgpObject).get(0);
                }
                pgpObject = pgpObjectFactory.nextObject();
                continue;
            }
            if (pgpObject instanceof PGPCompressedData) {
                PGPCompressedData cData = (PGPCompressedData)pgpObject;
                this.compressedStream = new BufferedInputStream(cData.getDataStream());
                pgpObjectFactory = new JcaPGPObjectFactory(this.compressedStream);
                pgpObject = pgpObjectFactory.nextObject();
                continue;
            }
            throw new PGPException("input is not PGPLiteralData - type unknown.");
        }
        InputStream literalDataStream = ((PGPLiteralData)pgpObject).getInputStream();
        if (!this.validateSignatureIfFound) {
            return literalDataStream;
        }
        onePassSignature.init((PGPContentVerifierBuilderProvider)new BcPGPContentVerifierBuilderProvider(), this.publicKeys.getPublicKey(onePassSignature.getKeyID()));
        ByteArrayOutputStream temporalStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[65536];
        while ((readBytesCount = literalDataStream.read(buffer)) > 0) {
            temporalStream.write(buffer, 0, readBytesCount);
            onePassSignature.update(buffer, 0, readBytesCount);
        }
        temporalStream.flush();
        PGPSignatureList signatureList = (PGPSignatureList)pgpObjectFactory.nextObject();
        PGPSignature signature = signatureList.get(0);
        PGPPublicKey signerPublicKey = this.publicKeys.getPublicKey(signature.getKeyID());
        signature.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), signerPublicKey);
        if (!onePassSignature.verify(signature)) {
            throw new PGPException("Signature verification failed while decrypting message.");
        }
        return new ByteArrayInputStream(temporalStream.toByteArray());
    }

    private PGPPrivateKey getPrivateKey(long keyID, String passPhrase) throws PGPException, NoSuchProviderException {
        PGPSecretKey pgpSecKey = this.configuredSecretKey ? this.secretKey : this.secretKeys.getSecretKey(keyID);
        if (this.configuredSecretKey && pgpSecKey.getKeyID() != keyID) {
            throw new PGPException(this.createInvalidKeyErrorMessage(pgpSecKey.getKeyID(), keyID));
        }
        try {
            return pgpSecKey != null ? pgpSecKey.extractPrivateKey(BouncyCastleUtil.PBE_SECRET_KEY_DECRYPTOR_BUILDER.build(passPhrase.toCharArray())) : null;
        }
        catch (PGPException e) {
            throw this.wrapWrongPassPhraseException(e, passPhrase, pgpSecKey.getKeyID());
        }
    }

    private String createInvalidKeyErrorMessage(Long configuredKeyId, Long validKeyId) {
        return String.format(INVALID_KEY_ERROR_MESSAGE, Long.toHexString(configuredKeyId).toUpperCase(), Long.toHexString(validKeyId).toUpperCase());
    }

    private PGPException wrapWrongPassPhraseException(PGPException pgpException, String invalidPassPhrase, Long keyId) {
        if (pgpException.getMessage().contains(CHECKSUM_MESSAGE)) {
            return new PGPException(this.createInvalidPassPhraseErrorMessage(invalidPassPhrase, keyId));
        }
        return pgpException;
    }

    private String createInvalidPassPhraseErrorMessage(String invalidPassPhrase, long keyId) {
        return String.format(INVALID_PASS_PHRASE_ERROR_MESSAGE, invalidPassPhrase, Long.toHexString(keyId).toUpperCase());
    }
}

