/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp;

import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.util.Calendar;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.mule.RequestContext;
import org.mule.api.EncryptionStrategy;
import org.mule.api.MuleEvent;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.security.CredentialsAccessor;
import org.mule.api.security.CryptoFailureException;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.pgp.DecryptStreamTransformer;
import org.mule.module.pgp.EncryptStreamTransformer;
import org.mule.module.pgp.EncryptionAlgorithm;
import org.mule.module.pgp.InvalidPublicKeyException;
import org.mule.module.pgp.PGPCryptInfo;
import org.mule.module.pgp.PGPDecryptInfo;
import org.mule.module.pgp.PGPEncryptAndSignInfo;
import org.mule.module.pgp.PGPKeyRing;
import org.mule.module.pgp.config.PGPOutputMode;
import org.mule.module.pgp.exception.MissingPGPKeyException;
import org.mule.module.pgp.i18n.PGPMessages;
import org.mule.module.pgp.util.BouncyCastleUtil;
import org.mule.module.pgp.util.ValidatorUtil;
import org.mule.security.AbstractNamedEncryptionStrategy;
import org.mule.util.SecurityUtils;

public class KeyBasedEncryptionStrategy
extends AbstractNamedEncryptionStrategy {
    protected static final Log logger = LogFactory.getLog(KeyBasedEncryptionStrategy.class);
    private static final String SIGNER_PRIVATE_KEY_NOT_FOUND_FOR_PRINCIPAL = "Signer private key not found for principal: ";
    private PGPKeyRing keyManager;
    private CredentialsAccessor credentialsAccessor;
    private boolean checkKeyExpirity = false;
    private Provider provider;
    private String encryptionAlgorithm;
    private int encryptionAlgorithmId;
    private PGPOutputMode pgpOutputMode;
    private String fileName;

    public void initialise() throws InitialisationException {
        if (!SecurityUtils.isFipsSecurityModel()) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        this.provider = SecurityUtils.getDefaultSecurityProvider();
        if (this.encryptionAlgorithm == null) {
            this.encryptionAlgorithm = EncryptionAlgorithm.AES_256.toString();
        }
        try {
            this.encryptionAlgorithmId = EncryptionAlgorithm.valueOf(this.encryptionAlgorithm).getNumericId();
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Could not initialise encryption strategy: invalid algorithm " + this.encryptionAlgorithm, e);
        }
    }

    public InputStream encrypt(InputStream data, Object cryptInfo) throws CryptoFailureException {
        try {
            PGPCryptInfo pgpCryptInfo = this.safeGetCryptInfo(cryptInfo);
            PGPPublicKey publicKey = pgpCryptInfo.getPublicKey();
            EncryptStreamTransformer encryptStreamTransformer = new EncryptStreamTransformer(publicKey, this.provider, this.encryptionAlgorithmId, this.pgpOutputMode, this.fileName);
            if (pgpCryptInfo.isSignRequested()) {
                PGPPrivateKey signerPrivateKey = pgpCryptInfo.getSignerPrivateKey();
                encryptStreamTransformer.signContentsWith(signerPrivateKey, pgpCryptInfo.getSignerPrincipal());
            }
            return encryptStreamTransformer.process(data);
        }
        catch (Exception e) {
            throw new CryptoFailureException((EncryptionStrategy)this, (Throwable)e);
        }
    }

    public InputStream decrypt(InputStream data, Object cryptInfo) throws CryptoFailureException {
        try {
            PGPSecretKey secretKey = this.keyManager.getConfiguredSecretKey();
            String secretPassPhrase = this.keyManager.getSecretPassphrase();
            PGPSecretKeyRingCollection secretKeys = this.keyManager.getSecretKeys();
            PGPPublicKeyRingCollection publicKeys = this.keyManager.getPublicKeys();
            if (secretPassPhrase == null) {
                throw new CryptoFailureException(PGPMessages.noSecretPassPhrase(), (EncryptionStrategy)this);
            }
            boolean verifySignatureIfFound = false;
            if (cryptInfo != null && cryptInfo instanceof PGPDecryptInfo) {
                verifySignatureIfFound = ((PGPDecryptInfo)cryptInfo).isVerifySignatureIfFound();
            }
            return new DecryptStreamTransformer(secretKey, secretKeys, publicKeys, secretPassPhrase).setValidateSignatureIfFound(verifySignatureIfFound).process(data);
        }
        catch (Exception e) {
            throw new CryptoFailureException((EncryptionStrategy)this, (Throwable)e);
        }
    }

    private PGPCryptInfo safeGetCryptInfo(Object cryptInfo) throws MissingPGPKeyException {
        if (cryptInfo == null) {
            return new PGPCryptInfo(this.getPublicKeyForCurrentEventValidatingIt(), false);
        }
        if (cryptInfo instanceof PGPEncryptAndSignInfo) {
            return this.doSafeGetEncryptAndSignInfo((PGPEncryptAndSignInfo)cryptInfo);
        }
        PGPCryptInfo info = (PGPCryptInfo)cryptInfo;
        this.checkKeyExpirity(info.getPublicKey());
        return info;
    }

    private PGPPublicKey getPublicKeyForCurrentEventValidatingIt() {
        MuleEvent event = RequestContext.getEvent();
        String principalId = (String)this.getCredentialsAccessor().getCredentials(event);
        PGPPublicKey publicKey = this.keyManager.getPublicKey(principalId);
        ValidatorUtil.validateNotNull(publicKey, PGPMessages.noPublicKeyForPrincipal(principalId));
        this.checkKeyExpirity(publicKey);
        return publicKey;
    }

    private PGPCryptInfo doSafeGetEncryptAndSignInfo(PGPEncryptAndSignInfo cryptInfo) {
        String signerPrincipal = cryptInfo.getSignerPrincipal();
        try {
            this.readSecretKeyBundleIfNecessary();
            Iterator signerSecretKeysIterator = this.keyManager.getSecretKeys().getKeyRings(signerPrincipal);
            if (!signerSecretKeysIterator.hasNext()) {
                throw new MissingPGPKeyException(MessageFactory.createStaticMessage((String)(SIGNER_PRIVATE_KEY_NOT_FOUND_FOR_PRINCIPAL + signerPrincipal)));
            }
            PGPSecretKey signerSecretKey = ((PGPSecretKeyRing)signerSecretKeysIterator.next()).getSecretKey();
            PGPPrivateKey signerPrivateKey = signerSecretKey.extractPrivateKey(BouncyCastleUtil.PBE_SECRET_KEY_DECRYPTOR_BUILDER.build(this.keyManager.getSecretPassphrase().toCharArray()));
            return new PGPCryptInfo(this.getPublicKeyForCurrentEventValidatingIt(), signerPrivateKey, signerPrincipal);
        }
        catch (PGPException e) {
            throw new MissingPGPKeyException(e);
        }
    }

    private void readSecretKeyBundleIfNecessary() {
        if (this.keyManager.getSecretKeys() == null) {
            this.keyManager.getConfiguredSecretKey();
        }
    }

    private void checkKeyExpirity(PGPPublicKey publicKey) {
        if (this.isCheckKeyExpirity() && publicKey.getValidDays() != 0) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(publicKey.getCreationTime());
            calendar.add(5, publicKey.getValidDays());
            if (!calendar.getTime().after(Calendar.getInstance().getTime())) {
                throw new InvalidPublicKeyException(PGPMessages.pgpPublicKeyExpired());
            }
        }
    }

    public PGPKeyRing getKeyManager() {
        return this.keyManager;
    }

    public void setKeyManager(PGPKeyRing keyManager) {
        this.keyManager = keyManager;
    }

    public CredentialsAccessor getCredentialsAccessor() {
        return this.credentialsAccessor;
    }

    public void setCredentialsAccessor(CredentialsAccessor credentialsAccessor) {
        this.credentialsAccessor = credentialsAccessor;
    }

    public void setPgpOutputMode(PGPOutputMode pgpOutputMode) {
        this.pgpOutputMode = pgpOutputMode;
    }

    public boolean isCheckKeyExpirity() {
        return this.checkKeyExpirity;
    }

    public void setCheckKeyExpirity(boolean checkKeyExpirity) {
        this.checkKeyExpirity = checkKeyExpirity;
    }

    public void setEncryptionAlgorithm(String encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

