/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.rss.config;

import java.text.SimpleDateFormat;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transformer.Transformer;
import org.mule.construct.Flow;
import org.mule.module.rss.routing.EntryLastUpdatedFilter;
import org.mule.module.rss.routing.FeedLastUpdatedFilter;
import org.mule.module.rss.routing.FeedSplitter;
import org.mule.module.rss.transformers.ObjectToRssFeed;
import org.mule.routing.MessageFilter;
import org.mule.tck.junit4.FunctionalTestCase;

public class RssNamespaceHandlerTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "namespace-config.xml";
    }

    @Test
    public void testFlowConfig() throws Exception {
        Flow flowConstruct = (Flow)muleContext.getRegistry().lookupObject("flowTest");
        Assert.assertNotNull((Object)flowConstruct);
        Assert.assertTrue((boolean)(flowConstruct.getMessageSource() instanceof InboundEndpoint));
        InboundEndpoint ep = (InboundEndpoint)flowConstruct.getMessageSource();
        Assert.assertEquals((long)2L, (long)ep.getMessageProcessors().size());
        MessageProcessor mp = (MessageProcessor)ep.getMessageProcessors().get(0);
        Assert.assertTrue((boolean)(mp instanceof FeedSplitter));
        mp = (MessageProcessor)ep.getMessageProcessors().get(1);
        Assert.assertTrue((boolean)(mp instanceof MessageFilter));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Assert.assertEquals((Object)sdf.parse("2009-10-01"), (Object)((EntryLastUpdatedFilter)((MessageFilter)mp).getFilter()).getLastUpdate());
    }

    @Test
    public void testGlobalFilterConfig() throws Exception {
        FeedLastUpdatedFilter filter = (FeedLastUpdatedFilter)muleContext.getRegistry().lookupObject("feedFilter");
        Assert.assertNotNull((Object)filter);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        Assert.assertEquals((Object)sdf.parse("2009-10-01 13:00:00"), (Object)filter.getLastUpdate());
        Assert.assertFalse((boolean)filter.isAcceptWithoutUpdateDate());
    }

    @Test
    public void testObjectToFeedTransformer() throws Exception {
        Transformer transformer = muleContext.getRegistry().lookupTransformer("ObjectToFeed");
        Assert.assertNotNull((Object)transformer);
        Assert.assertTrue((boolean)(transformer instanceof ObjectToRssFeed));
    }
}

