/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.rss.transformers;

import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.io.SyndFeedInput;
import com.rometools.rome.io.XmlReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractDiscoverableTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class ObjectToRssFeed
extends AbstractDiscoverableTransformer {
    public ObjectToRssFeed() {
        this.registerSourceType(DataTypeFactory.BYTE_ARRAY);
        this.registerSourceType(DataTypeFactory.STRING);
        this.registerSourceType(DataTypeFactory.INPUT_STREAM);
        this.registerSourceType(DataTypeFactory.create(Document.class));
        this.registerSourceType(DataTypeFactory.create(InputSource.class));
        this.registerSourceType(DataTypeFactory.create(File.class));
        this.setReturnDataType(DataTypeFactory.create(SyndFeed.class));
    }

    protected Object doTransform(Object src, String outputEncoding) throws TransformerException {
        SyndFeedInput feedInput = new SyndFeedInput();
        SyndFeed feed = null;
        try {
            if (src instanceof String) {
                feed = feedInput.build((Reader)new StringReader(src.toString()));
            } else if (src instanceof InputStream) {
                feed = feedInput.build((Reader)new XmlReader((InputStream)src));
            } else if (src instanceof byte[]) {
                feed = feedInput.build((Reader)new XmlReader((InputStream)new ByteArrayInputStream((byte[])src)));
            } else if (src instanceof Document) {
                feed = feedInput.build((Document)src);
            } else if (src instanceof InputSource) {
                feed = feedInput.build((InputSource)src);
            } else if (src instanceof File) {
                feed = feedInput.build((File)src);
            }
            return feed;
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
    }
}

