
package org.mule.modules.salesforce.config.spring;

import org.springframework.beans.factory.xml.NamespaceHandlerSupport;


/**
 * Registers bean definitions parsers for handling elements in <code>http://www.mulesoft.org/schema/mule/sfdc</code>.
 * 
 */
public class SalesforceModuleNamespaceHandler
    extends NamespaceHandlerSupport
{


    /**
     * Invoked by the {@link DefaultBeanDefinitionDocumentReader} after construction but before any custom elements are parsed. 
     * @see NamespaceHandlerSupport#registerBeanDefinitionParser(String, BeanDefinitionParser)
     * 
     */
    public void init() {
        registerBeanDefinitionParser("config", new SalesforceModuleConfigDefinitionParser());
        registerBeanDefinitionParser("create", new CreateDefinitionParser());
        registerBeanDefinitionParser("create-bulk", new CreateBulkDefinitionParser());
        registerBeanDefinitionParser("create-single", new CreateSingleDefinitionParser());
        registerBeanDefinitionParser("update", new UpdateDefinitionParser());
        registerBeanDefinitionParser("update-bulk", new UpdateBulkDefinitionParser());
        registerBeanDefinitionParser("upsert", new UpsertDefinitionParser());
        registerBeanDefinitionParser("upsert-bulk", new UpsertBulkDefinitionParser());
        registerBeanDefinitionParser("describe-global", new DescribeGlobalDefinitionParser());
        registerBeanDefinitionParser("query", new QueryDefinitionParser());
        registerBeanDefinitionParser("query-single", new QuerySingleDefinitionParser());
        registerBeanDefinitionParser("convert-lead", new ConvertLeadDefinitionParser());
        registerBeanDefinitionParser("empty-recycle-bin", new EmptyRecycleBinDefinitionParser());
        registerBeanDefinitionParser("delete", new DeleteDefinitionParser());
        registerBeanDefinitionParser("get-deleted-range", new GetDeletedRangeDefinitionParser());
        registerBeanDefinitionParser("describe-sobject", new DescribeSObjectDefinitionParser());
        registerBeanDefinitionParser("get-deleted", new GetDeletedDefinitionParser());
        registerBeanDefinitionParser("publish-topic", new PublishTopicDefinitionParser());
        registerBeanDefinitionParser("subscribe-topic", new SubscribeTopicDefinitionParser());
    }

}
