
package org.mule.modules.salesforce.config;

import org.mule.modules.salesforce.processors.BatchResultMessageProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class BatchResultDefinitionParser
    extends AbstractDefinitionParser
{


    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(BatchResultMessageProcessor.class.getName());
        parseConfigRef(element, builder);
        if (hasAttribute(element, "batchInfo-ref")) {
            if (element.getAttribute("batchInfo-ref").startsWith("#")) {
                builder.addPropertyValue("batchInfo", element.getAttribute("batchInfo-ref"));
            } else {
                builder.addPropertyValue("batchInfo", (("#[registry:"+ element.getAttribute("batchInfo-ref"))+"]"));
            }
        }
        parseProperty(builder, element, "retryMax");
        parseProperty(builder, element, "username");
        parseProperty(builder, element, "password");
        parseProperty(builder, element, "securityToken");
        BeanDefinition definition = builder.getBeanDefinition();
        setNoRecurseOnDefinition(definition);
        attachProcessorDefinition(parserContext, definition);
        return definition;
    }

}
