
package org.mule.modules.salesforce.config;

import org.mule.modules.salesforce.processors.ConvertLeadMessageProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class ConvertLeadDefinitionParser
    extends AbstractDefinitionParser
{


    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ConvertLeadMessageProcessor.class.getName());
        parseConfigRef(element, builder);
        parseProperty(builder, element, "leadId");
        parseProperty(builder, element, "contactId");
        parseProperty(builder, element, "accountId");
        parseProperty(builder, element, "overWriteLeadSource");
        parseProperty(builder, element, "doNotCreateOpportunity");
        parseProperty(builder, element, "opportunityName");
        parseProperty(builder, element, "convertedStatus");
        parseProperty(builder, element, "sendEmailToOwner");
        parseProperty(builder, element, "retryMax");
        parseProperty(builder, element, "username");
        parseProperty(builder, element, "password");
        parseProperty(builder, element, "securityToken");
        BeanDefinition definition = builder.getBeanDefinition();
        setNoRecurseOnDefinition(definition);
        attachProcessorDefinition(parserContext, definition);
        return definition;
    }

}
