
package org.mule.modules.salesforce.config;

import org.mule.modules.salesforce.processors.GetUpdatedRangeMessageProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class GetUpdatedRangeDefinitionParser
    extends AbstractDefinitionParser
{


    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(GetUpdatedRangeMessageProcessor.class.getName());
        parseConfigRef(element, builder);
        parseProperty(builder, element, "type");
        if (hasAttribute(element, "startTime-ref")) {
            if (element.getAttribute("startTime-ref").startsWith("#")) {
                builder.addPropertyValue("startTime", element.getAttribute("startTime-ref"));
            } else {
                builder.addPropertyValue("startTime", (("#[registry:"+ element.getAttribute("startTime-ref"))+"]"));
            }
        }
        if (hasAttribute(element, "endTime-ref")) {
            if (element.getAttribute("endTime-ref").startsWith("#")) {
                builder.addPropertyValue("endTime", element.getAttribute("endTime-ref"));
            } else {
                builder.addPropertyValue("endTime", (("#[registry:"+ element.getAttribute("endTime-ref"))+"]"));
            }
        }
        parseProperty(builder, element, "retryMax");
        parseProperty(builder, element, "username");
        parseProperty(builder, element, "password");
        parseProperty(builder, element, "securityToken");
        BeanDefinition definition = builder.getBeanDefinition();
        setNoRecurseOnDefinition(definition);
        attachProcessorDefinition(parserContext, definition);
        return definition;
    }

}
